/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.extractor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.ccil.cowan.tagsoup.Parser;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.crawler.web.extractor.LinkExtractorHtml;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LinkExtractorHtmlSoup
implements LinkExtractorHtml {
    @Override
    public Collection<String> extractLinks(InputStream input, AnyMap parameters) throws Exception {
        LinkContentHandler linkHandler = new LinkContentHandler();
        Parser parser = new Parser();
        parser.setContentHandler(linkHandler);
        parser.setFeature("http://xml.org/sax/features/namespaces", false);
        parser.parse(new InputSource(input));
        return linkHandler._links;
    }

    private static class LinkContentHandler
    extends DefaultHandler {
        private final Collection<String> _links = new ArrayList<String>();

        private LinkContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String link = null;
            if (qName.equalsIgnoreCase("a")) {
                link = atts.getValue("href");
            } else if (qName.equalsIgnoreCase("frame") || qName.equalsIgnoreCase("img")) {
                link = atts.getValue("src");
            }
            if (link != null) {
                this._links.add(link);
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
        }
    }
}

