/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.List;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;

public class JobDefinition
extends DefinitionBase {
    public static final String KEY_JOBS = "jobs";
    public static final String KEY_MODES = "modes";
    public static final String KEY_PARAMETERS = "parameters";
    public static final String KEY_WORKFLOW = "workflow";
    private final List<JobRunMode> _modes;
    private final AnyMap _parameters;
    private final String _workflow;

    public JobDefinition(AnyMap job) throws InvalidDefinitionException {
        super(job);
        this._workflow = AccessAny.getStringRequired((AnyMap)job, (String)KEY_WORKFLOW);
        Any parametersAny = (Any)job.get((Object)KEY_PARAMETERS);
        if (parametersAny == null) {
            this._parameters = null;
        } else {
            if (!parametersAny.isMap()) {
                throw new InvalidDefinitionException("Error reading jobs record object. Field parameter is not of type MAP.");
            }
            try {
                this._parameters = (AnyMap)parametersAny;
            }
            catch (Exception e) {
                throw new InvalidDefinitionException("Error reading parameters for jobs record object.", (Throwable)e);
            }
        }
        AnySeq modesAny = job.getSeq(KEY_MODES);
        try {
            this._modes = JobRunMode.parseModes(modesAny);
        }
        catch (InvalidDefinitionException ex) {
            throw new InvalidDefinitionException("Job '" + this._name + "': " + ex.getMessage());
        }
    }

    public static JobDefinition parseJob(AnyMap jobAny) throws InvalidDefinitionException {
        JobDefinition job = null;
        try {
            job = new JobDefinition(jobAny);
        }
        catch (InvalidDefinitionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
        }
        return job;
    }

    public List<JobRunMode> getJobRunModes() {
        return this._modes;
    }

    public JobRunMode getDefaultJobRunMode() {
        if (this._modes == null) {
            return null;
        }
        return this.getJobRunModes().get(0);
    }

    public AnyMap getParameters() {
        return this._parameters;
    }

    public String getWorkflow() {
        return this._workflow;
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap jobAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                if (this._modes != null) {
                    jobAny.put(KEY_MODES, (Any)JobRunMode.toAny(this._modes));
                }
                if (this._parameters != null) {
                    jobAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
                jobAny.put(KEY_WORKFLOW, this._workflow);
            }
            return jobAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for job " + this._name, ex);
        }
    }
}

