/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.activities;

import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.v2.CompilerContext;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.OActivity;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.activities.PipeletActivityValidator;
import org.eclipse.smila.processing.bpel.activities.PipeletHolder;
import org.eclipse.smila.processing.bpel.activities.PipeletManager;
import org.w3c.dom.Element;

public class PipeletExtensionBundle
extends AbstractExtensionBundle {
    private static final PipeletActivityValidator VALIDATOR = new PipeletActivityValidator();

    public String getNamespaceURI() {
        return "http://www.eclipse.org/smila/processor";
    }

    public void registerExtensionActivities() {
        this.registerExtensionOperation("invokePipelet", InvokePipeletActivity.class);
    }

    private static void invokeActivity(ExtensionContext context, Element element) {
        OActivity activity = context.getOActivity();
        String key = PipeletExtensionBundle.getActivityKey(activity);
        PipeletManager.getServiceInstance().invokeActivity(key, context, element);
    }

    private static void registerActivity(OExtensionActivity activity, ExtensibleElement element, CompilerContext compilerContext) {
        OProcess process = activity.getOwner();
        String key = PipeletExtensionBundle.getActivityKey((OActivity)activity);
        Element content = element.getNestedElement();
        PipeletHolder pipeletHolder = VALIDATOR.validateActivity(process, activity, content, key, compilerContext);
        try {
            PipeletManager.getServiceInstance().registerActivity(pipeletHolder);
        }
        catch (ProcessingException ex) {
            throw new CompilationException(VALIDATOR.createErrorCompilationMessage(key, "Error initialising pipelet: " + (Object)((Object)ex)), (Throwable)ex);
        }
    }

    private static String getActivityKey(OActivity activity) {
        return String.valueOf(activity.getOwner().getName()) + "/" + activity.name + "@" + activity.debugInfo.startLine;
    }

    public static class InvokePipeletActivity
    implements ExtensionOperation,
    ExtensionValidator {
        public void run(Object contexto, Element element) throws FaultException {
            ExtensionContext context = (ExtensionContext)contexto;
            PipeletExtensionBundle.invokeActivity(context, element);
        }

        public void validate(Object compiler, ExtensibleElement element) {
            CompilerContext compilerContext = (CompilerContext)compiler;
            OExtensionActivity activity = (OExtensionActivity)compilerContext.getCurrent();
            PipeletExtensionBundle.registerActivity(activity, element, compilerContext);
        }
    }
}

