/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class DeltaCheckerWorker
implements Worker {
    private static final String WORKER_NAME = "deltaChecker";
    private static final String INPUT_SLOT_NAME = "recordsToCheck";
    private static final String OUTPUT_SLOT_NAME = "updatedRecords";
    private final Log _log = LogFactory.getLog(this.getClass());
    private DeltaService _deltaService;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        String jobRunId = (String)taskContext.getTask().getProperties().get("jobRunId");
        if (jobRunId == null) {
            throw new IllegalArgumentException("Missing property 'jobRunId' in task: " + taskContext.getTask());
        }
        Inputs inputs = taskContext.getInputs();
        RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
        Outputs outputs = taskContext.getOutputs();
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
        Record record = recordInput.getRecord();
        while (record != null) {
            Record updatedRecord = this.checkRecord(taskContext, jobRunId, record);
            if (updatedRecord != null) {
                recordOutput.writeRecord(updatedRecord);
            }
            record = recordInput.getRecord();
        }
    }

    private Record checkRecord(TaskContext taskContext, String jobRunId, Record record) throws ObjectStoreException, IOException {
        String deltaHash = record.getMetadata().getStringValue("_deltaHash");
        if (deltaHash == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Record " + record.getId() + " has no hash attribute value, is added to output."));
            }
            return record;
        }
        try {
            long startDelta = taskContext.getTimestamp();
            State deltaStatus = this._deltaService.checkState(record.getSource(), record.getId(), jobRunId, deltaHash);
            taskContext.measureTime("invokeDeltaService", startDelta);
            if (deltaStatus != State.UPTODATE) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Record " + record.getId() + " will be added to output, has status " + (Object)((Object)deltaStatus)));
                }
                if (deltaStatus == State.CHANGED) {
                    record.getMetadata().put("_update", Boolean.valueOf(true));
                }
                return record;
            }
        }
        catch (Exception e) {
            taskContext.getLog().error("Error checking record " + record.getId(), (Throwable)e);
        }
        this._log.debug((Object)("Record " + record.getId() + " is up to date"));
        return null;
    }

    public void setDeltaService(DeltaService service) {
        this._deltaService = service;
    }

    public void unsetDeltaService(DeltaService service) {
        if (this._deltaService == service) {
            this._deltaService = null;
        }
    }
}

