/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing;

import java.io.IOException;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.importing.State;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class UpdatePusherWorker
implements Worker {
    private static final String WORKER_NAME = "updatePusher";
    private static final String INPUT_SLOT_NAME = "recordsToPush";
    private static final String OUTPUT_SLOT_NAME = "pushedRecords";
    private static final String JOB_TO_PUSH_TO_PARAM = "jobToPushTo";
    private BulkbuilderService _bulkbuilder;
    private DeltaService _deltaIndexing;

    public void perform(TaskContext taskContext) throws Exception {
        String jobName = taskContext.getTaskParameters().getStringValue(JOB_TO_PUSH_TO_PARAM);
        if (jobName == null) {
            throw new IllegalArgumentException("Missing parameter 'jobToPushTo' in task: " + taskContext.getTask());
        }
        String jobRunId = (String)taskContext.getTask().getProperties().get("jobRunId");
        if (jobRunId == null) {
            throw new IllegalArgumentException("Missing parameter 'jobRunId' in task: " + taskContext.getTask());
        }
        Inputs inputs = taskContext.getInputs();
        RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
        Outputs outputs = taskContext.getOutputs();
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
        Record record = recordInput.getRecord();
        while (record != null) {
            String deltaHash = record.getMetadata().getStringValue("_deltaHash");
            if (deltaHash != null) {
                if (this._deltaIndexing.checkState(record.getSource(), record.getId(), jobRunId, deltaHash) != State.UPTODATE) {
                    this.pushToBulkbuilder(taskContext, jobName, record, recordOutput);
                    this._deltaIndexing.markAsUpdated(record.getSource(), record.getId(), jobRunId, deltaHash);
                }
            } else {
                this.pushToBulkbuilder(taskContext, jobName, record, recordOutput);
            }
            record = recordInput.getRecord();
        }
    }

    private void pushToBulkbuilder(TaskContext taskContext, String jobName, Record record, RecordOutput recordOutput) throws BulkbuilderException, ObjectStoreException, IOException {
        try {
            this._bulkbuilder.addRecord(jobName, record);
            if (recordOutput != null) {
                recordOutput.writeRecord(record);
            }
        }
        catch (InvalidRecordException ex) {
            taskContext.getLog().warn("Could not submit record '" + record.getId() + "' to bulkbuilder.", (Throwable)ex);
        }
    }

    public String getName() {
        return WORKER_NAME;
    }

    public void setDeltaIndexingService(DeltaService service) {
        this._deltaIndexing = service;
    }

    public void unsetDeltaIndexingService(DeltaService service) {
        if (this._deltaIndexing == service) {
            this._deltaIndexing = null;
        }
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._bulkbuilder = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._bulkbuilder == service) {
            this._bulkbuilder = null;
        }
    }
}

