/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.compound.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.CrawlerCallback;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.compound.AbstractCompoundCrawler;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.CompoundHandling;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.ElementAttributeType;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.DataReferenceFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.utils.file.EncodingHelper;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class ZipCompoundCrawler
extends AbstractCompoundCrawler {
    public static final String COMPOUND_METADATA_ELEMENT = "_compounds";
    private static final String BUNDLE_ID = "org.eclipse.smila.connectivity.framework.compound.zip";
    private static final int QUEUE_POLL_WAITING = 300;
    private static final int HAS_NEXT_WAITING = 50;
    private static final int CAPACITY = 100;
    private static final int STEP = 10;
    private ZipFile _zipFile;
    private ArrayBlockingQueue<DataReference> _queue;
    private ZipEntryProducerThread _producerThread;
    private Map<ConnectivityId, ZipEntry> _entryMap;
    private CompoundHandling.CompoundAttribute[] _compoundAttributes;
    private String[] _attachmentNames;
    private boolean _initialized;
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void initialize(DataSourceConnectionConfig config) throws CrawlerException, CrawlerCriticalException {
        if (config == null) {
            throw new CrawlerCriticalException("parameter config is null");
        }
        Record record = this.getCompoundRecord();
        if (record == null) {
            throw new CrawlerCriticalException("the compound record was not set");
        }
        try {
            CompoundHandling.CompoundAttributes attributes = config.getCompoundHandling().getCompoundAttributes();
            List attrs = attributes.getCompoundAttributes();
            this._compoundAttributes = attrs.toArray(new CompoundHandling.CompoundAttribute[attrs.size()]);
            ArrayList<String> attachmentsNames = new ArrayList<String>();
            CompoundHandling.CompoundAttribute[] compoundAttributeArray = this._compoundAttributes;
            int n = this._compoundAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                CompoundHandling.CompoundAttribute a = compoundAttributeArray[n2];
                if (a.isAttachment()) {
                    attachmentsNames.add(a.getName());
                }
                ++n2;
            }
            this._attachmentNames = attachmentsNames.toArray(new String[attachmentsNames.size()]);
            String contentAttachmentName = config.getCompoundHandling().getContentAttachment();
            byte[] content = record.getAttachmentAsBytes(contentAttachmentName);
            if (content == null) {
                content = new byte[]{};
            }
            File workingDir = WorkspaceHelper.createWorkingDir((String)BUNDLE_ID);
            File file = new File(workingDir, this.createTempFileNape(new ConnectivityId(record.getSource(), record.getId())));
            IOUtils.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)new FileOutputStream(file));
            this._zipFile = new ZipFile(file);
            this._queue = new ArrayBlockingQueue(100);
            this._entryMap = new HashMap<ConnectivityId, ZipEntry>();
            this._producerThread = new ZipEntryProducerThread((CrawlerCallback)this);
            this._producerThread.start();
            this._initialized = true;
        }
        catch (Throwable e) {
            block10: {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Error during initialization", e);
                }
                try {
                    this.close();
                }
                catch (Exception ex) {
                    if (!this._log.isErrorEnabled()) break block10;
                    this._log.error((Object)"Error during close in initialization", (Throwable)ex);
                }
            }
            throw new CrawlerCriticalException("Error during initialization", e);
        }
    }

    private String createTempFileNape(ConnectivityId id) {
        return id.getIdHash();
    }

    /*
     * Unable to fully structure code
     */
    public DataReference[] getNext() throws CrawlerException, CrawlerCriticalException {
        if (this._initialized) ** GOTO lbl15
        throw new CrawlerCriticalException("ZipCompoundCrawler was not initialized");
lbl-1000:
        // 1 sources

        {
            refList = new ArrayList<DataReference>();
            try {
                ref = this._queue.poll(300L, TimeUnit.MILLISECONDS);
                if (ref != null) {
                    refList.add(ref);
                    size = this._queue.drainTo(refList, 9);
                    return refList.toArray(new DataReference[size + 1]);
                }
                continue;
            }
            catch (InterruptedException e) {
                if (!this._log.isTraceEnabled()) continue;
                this._log.trace((Object)"InterruptedException in getNext(): ", (Throwable)e);
            }
lbl15:
            // 4 sources

            ** while (this.hasNext())
        }
lbl16:
        // 1 sources

        return null;
    }

    public void close() throws CrawlerException {
        this._initialized = false;
        if (this._zipFile != null) {
            block3: {
                try {
                    this._zipFile.close();
                }
                catch (IOException e) {
                    String msg = "Could not close temporary zip file " + this._zipFile.getName();
                    if (!this._log.isErrorEnabled()) break block3;
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
            File file = new File(this._zipFile.getName());
            file.delete();
            this._zipFile = null;
        }
    }

    public AnyMap getMetadata(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        if (!this._initialized) {
            throw new CrawlerCriticalException("ZipCompoundCrawler was not initialized");
        }
        ZipEntry zipEntry = this._entryMap.get(id);
        if (zipEntry == null) {
            throw new CrawlerException("Could not find ZipEntry for id " + id);
        }
        AnyMap metadataObject = this.getCompoundRecord().getFactory().createAnyMap();
        CompoundHandling.CompoundAttribute[] compoundAttributeArray = this._compoundAttributes;
        int n = this._compoundAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            CompoundHandling.CompoundAttribute attribute = compoundAttributeArray[n2];
            if (!attribute.isAttachment()) {
                Serializable value = this.readAttribute(zipEntry, attribute, true);
                if (attribute.getElementAttribute() == ElementAttributeType.PATH) {
                    AnySeq parentCompounds = this.getCompoundRecord().getMetadata().getSeq(COMPOUND_METADATA_ELEMENT);
                    if (this.getCompoundRecord() != null && this.getCompoundRecord().getMetadata().getStringValue(attribute.getName()) != null) {
                        AnySeq newCompounds = parentCompounds == null ? this.getCompoundRecord().getFactory().createAnySeq() : parentCompounds.getFactory().cloneAnySeq(parentCompounds);
                        newCompounds.add((Object)this.getCompoundRecord().getFactory().createStringValue(this.getCompoundRecord().getMetadata().getStringValue(attribute.getName())));
                        metadataObject.put(COMPOUND_METADATA_ELEMENT, (Any)newCompounds);
                    }
                }
                if (value != null) {
                    try {
                        metadataObject.put(attribute.getName(), (Any)this.getCompoundRecord().getFactory().parseFromObject((Object)value));
                    }
                    catch (Throwable e) {
                        throw new CrawlerException(e);
                    }
                }
            }
            ++n2;
        }
        return metadataObject;
    }

    public String[] getAttachmentNames(ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
        if (!this._initialized) {
            throw new CrawlerCriticalException("ZipCompoundCrawler was not initialized");
        }
        return this._attachmentNames;
    }

    public byte[] getAttachment(ConnectivityId id, String name) throws CrawlerException, CrawlerCriticalException {
        if (!this._initialized) {
            throw new CrawlerCriticalException("ZipCompoundCrawler was not initialized");
        }
        ZipEntry zipEntry = this._entryMap.get(id);
        if (zipEntry == null) {
            throw new CrawlerException("Could not find ZipEntry for id " + id);
        }
        CompoundHandling.CompoundAttribute[] compoundAttributeArray = this._compoundAttributes;
        int n = this._compoundAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            CompoundHandling.CompoundAttribute attribute = compoundAttributeArray[n2];
            if (attribute.getName().equals(name)) {
                return this.readAttachment(zipEntry, attribute);
            }
            ++n2;
        }
        throw new CrawlerException(String.format("Unable to find attachment definition for [%s]", name));
    }

    public void dispose(ConnectivityId id) {
        this._entryMap.remove(id);
    }

    private boolean hasNext() {
        while (this._producerThread != null && this._queue.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                if (!this._log.isTraceEnabled()) continue;
                this._log.trace((Object)"InterruptedException in hasNext(): ", (Throwable)e);
            }
        }
        return !this._queue.isEmpty();
    }

    private byte[] readZipEntryContent(ZipEntry zipEntry) throws CrawlerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            try {
                in = this._zipFile.getInputStream(zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException e) {
                String msg = "Error reading content of ZipEntry '" + zipEntry.getName() + "' of record id " + this.getCompoundRecord().getId();
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)msg, (Throwable)e);
                }
                throw new CrawlerException(msg, (Throwable)e);
            }
            catch (Throwable e) {
                String msg = "Error reading content of ZipEntry '" + zipEntry.getName() + "' of record id " + this.getCompoundRecord().getId();
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)msg, e);
                }
                throw new CrawlerException(msg, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly((OutputStream)out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return out.toByteArray();
    }

    private Serializable readAttribute(ZipEntry zipEntry, CompoundHandling.CompoundAttribute attribute, boolean forceByteToString) throws CrawlerException {
        switch (attribute.getElementAttribute()) {
            case NAME: {
                return FilenameUtils.getName((String)zipEntry.getName());
            }
            case FILE_EXTENSION: {
                return FilenameUtils.getExtension((String)zipEntry.getName());
            }
            case PATH: {
                return zipEntry.getName();
            }
            case LAST_MODIFIED_DATE: {
                return new Date(zipEntry.getTime());
            }
            case SIZE: {
                return Long.valueOf(zipEntry.getSize());
            }
            case CONTENT: {
                try {
                    byte[] bytes = this.readZipEntryContent(zipEntry);
                    if (forceByteToString) {
                        String encoding = EncodingHelper.getEncoding((byte[])bytes);
                        if (encoding != null) {
                            return IOUtils.toString((InputStream)new ByteArrayInputStream(bytes), (String)encoding);
                        }
                        return IOUtils.toString((InputStream)new ByteArrayInputStream(bytes));
                    }
                    return bytes;
                }
                catch (IOException e) {
                    throw new CrawlerException((Throwable)e);
                }
            }
        }
        throw new RuntimeException("Unknown compound element attributes type " + attribute.getElementAttribute());
    }

    private byte[] readAttachment(ZipEntry zipEntry, CompoundHandling.CompoundAttribute attribute) throws CrawlerException {
        Serializable value = this.readAttribute(zipEntry, attribute, false);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return ((String)((Object)value)).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new CrawlerException((Throwable)e);
                }
            }
            if (value instanceof byte[]) {
                return (byte[])value;
            }
        }
        return null;
    }

    public CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> getCounterHelper() {
        return null;
    }

    private class ZipEntryProducerThread
    extends Thread {
        private final CrawlerCallback _crawlerCallback;

        public ZipEntryProducerThread(CrawlerCallback crawlerCallback) {
            this._crawlerCallback = crawlerCallback;
        }

        @Override
        public void run() {
            try {
                try {
                    Enumeration<? extends ZipEntry> entries;
                    if (ZipCompoundCrawler.this._zipFile != null && (entries = ZipCompoundCrawler.this._zipFile.entries()) != null) {
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            if (entry == null || entry.isDirectory()) continue;
                            ConnectivityId parentId = new ConnectivityId(ZipCompoundCrawler.this.getCompoundRecord().getSource(), ZipCompoundCrawler.this.getCompoundRecord().getId());
                            ConnectivityId id = new ConnectivityId(parentId, entry.getName());
                            String hash = ConnectivityHashFactory.getInstance().createHash(Long.toString(entry.getTime()));
                            DataReference dataRef = DataReferenceFactory.getInstance().createDataReference(this._crawlerCallback, id, hash);
                            boolean added = false;
                            while (!added) {
                                added = ZipCompoundCrawler.this._queue.add(dataRef);
                                ZipCompoundCrawler.this._entryMap.put(id, entry);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    if (ZipCompoundCrawler.this._log.isErrorEnabled()) {
                        ZipCompoundCrawler.this._log.error((Object)"Producer error", ex);
                    }
                    ZipCompoundCrawler.this._producerThread = null;
                    if (ZipCompoundCrawler.this._log.isInfoEnabled()) {
                        ZipCompoundCrawler.this._log.info((Object)"ZipEntry producer thread finished!");
                    }
                }
            }
            finally {
                ZipCompoundCrawler.this._producerThread = null;
                if (ZipCompoundCrawler.this._log.isInfoEnabled()) {
                    ZipCompoundCrawler.this._log.info((Object)"ZipEntry producer thread finished!");
                }
            }
        }
    }
}

