/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import org.apache.commons.lang.NullArgumentException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.helper.ResultAccessor;

public class ResultBuilder
extends ResultAccessor {
    public ResultBuilder(String workflowName, Record result) {
        super(workflowName, result);
        this._result.getMetadata().getSeq("records", true);
    }

    public AnyMap addResultItem(String id, Double score) {
        AnyMap resultItem = this.getResultRecords().getFactory().createAnyMap();
        this.getResultRecords().add((Object)resultItem);
        resultItem.put("_recordid", id);
        resultItem.put("_weight", (Number)score);
        return resultItem;
    }

    public void setCount(Long count) {
        this._result.getMetadata().put("count", (Number)count);
    }

    public void setRuntime(Long millis) {
        this._result.getMetadata().put("runtime", (Number)millis);
    }

    public AnySeq addFacet(String facetName) {
        AnyMap facets = this._result.getMetadata().getMap("facets", true);
        return facets.getSeq(facetName, true);
    }

    public AnyMap addFacetValue(AnySeq facet, Any value, Long count) {
        if (facet == null) {
            throw new NullArgumentException("facet must not be null");
        }
        if (value == null) {
            throw new NullArgumentException("value must not be null");
        }
        AnyMap facetValue = facet.getFactory().createAnyMap();
        facetValue.put("value", value);
        if (count != null) {
            facetValue.put("count", (Number)count);
        }
        facet.add((Object)facetValue);
        return facetValue;
    }

    public AnyMap addFacetValue(AnySeq facet, Object value, Long count) {
        Value autoConvertValue = facet.getFactory().autoConvertValue(value);
        return this.addFacetValue(facet, (Any)autoConvertValue, count);
    }
}

