/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.json;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonHttpUtils;
import org.eclipse.smila.http.server.util.ARequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;

public abstract class JsonRequestHandler
extends ARequestHandler {
    protected static final DataFactory FACTORY = DataFactory.DEFAULT;
    protected static final JsonHttpUtils HTTP_UTILS = new JsonHttpUtils();
    private final Log _log = LogFactory.getLog(this.getClass());
    private String _requestHost = "";

    public abstract Object process(String var1, String var2, Record var3) throws Exception;

    @Override
    public void handle(HttpExchange exchange) {
        boolean closeConnection = false;
        Object resultObject = null;
        String method = exchange.getRequestMethod();
        String requestUri = exchange.getRequestURI();
        String headerHost = exchange.getRequestHeader("Host");
        if (headerHost != null) {
            this._requestHost = headerHost;
        }
        Record inputRecord = null;
        try {
            if (!this.isValidMethod(method, requestUri)) {
                throw new UnsupportedMethodException("Unsupported http method '" + method + "'");
            }
            inputRecord = HTTP_UTILS.convertRequest(exchange);
            resultObject = this.process(method, requestUri, inputRecord);
        }
        catch (Throwable error) {
            this._log.warn((Object)("Error processing " + method + " " + requestUri), error);
            closeConnection = this.writeErrorResult(exchange, error, inputRecord);
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                closeConnection = this.writeSuccessResult(exchange, resultObject, inputRecord);
            }
            catch (IOException ex) {
                this._log.warn((Object)"Error writing the response. Maybe client has closed the connection.", (Throwable)ex);
                closeConnection = true;
                try {
                    if (closeConnection) {
                        IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                    }
                    exchange.getResponseStream().flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            try {
                if (closeConnection) {
                    IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
                } else {
                    exchange.getResponseStream().flush();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (closeConnection) {
                IOUtils.closeQuietly((OutputStream)exchange.getResponseStream());
            } else {
                exchange.getResponseStream().flush();
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method);
    }

    protected boolean writeSuccessResult(HttpExchange exchange, Object resultObject, Record inputRecord) throws IOException {
        int statusCode = this.getSuccessStatus(exchange.getRequestMethod(), exchange.getRequestURI(), inputRecord, resultObject);
        boolean closeConnection = HTTP_UTILS.prepareResponseHeader(exchange, statusCode, resultObject != null);
        this.writeResultObject(exchange.getResponseStream(), resultObject);
        return closeConnection;
    }

    protected int getSuccessStatus(String method, String requestUri) {
        return 200;
    }

    protected int getSuccessStatus(String requestMethod, String requestUri, Record inputRecord, Object resultObject) {
        return this.getSuccessStatus(requestMethod, requestUri);
    }

    protected void writeResultObject(OutputStream responseStream, Object resultObject) throws IOException {
        HTTP_UTILS.writeResultObject(responseStream, resultObject);
    }

    protected boolean writeErrorResult(HttpExchange exchange, Throwable error, Record inputRecord) throws IOException {
        int errorCode = this.getErrorStatus(exchange.getRequestMethod(), exchange.getRequestMethod(), error);
        boolean writeErrorDetails = !"HEAD".equals(exchange.getRequestMethod());
        boolean closeConnection = HTTP_UTILS.prepareResponseHeader(exchange, errorCode, writeErrorDetails);
        if (writeErrorDetails) {
            HTTP_UTILS.writeErrorDetails(exchange, error);
        }
        return closeConnection;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        return HTTP_UTILS.getErrorStatus(ex);
    }

    protected String getRequestHost() {
        return this._requestHost;
    }
}

