/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.file.FileToRecordConverter;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class FileFetcherWorker
implements Worker {
    public static final String NAME = "fileFetcher";
    public static final String INPUT_SLOT = "filesToFetch";
    public static final String OUTPUT_SLOT = "files";
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final FileToRecordConverter _converter = new FileToRecordConverter(DataFactory.DEFAULT);

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        Record record;
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
        do {
            if ((record = recordInput.getRecord()) == null) continue;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("fetching content for record " + record.getId()));
            }
            this.fetch(record, taskContext);
            recordOutput.writeRecord(record);
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("added record " + record.getId()));
        } while (record != null);
    }

    private void fetch(Record record, TaskContext taskContext) throws IOException {
        try {
            if (!record.hasAttachment("file.content")) {
                long time = taskContext.getTimestamp();
                this._converter.addAttachment(record);
                taskContext.measureTime("fetchContent", time);
            }
        }
        catch (IOException e) {
            taskContext.getLog().warn("Failed to fetch file for record " + record.getId(), (Throwable)e);
        }
    }
}

