/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.state.objectstore;

import java.util.Properties;

public class StateStoreConfiguration {
    public static final String KEY_SHARDLENGTH = "shard.length";
    public static final String KEY_SEGMENTLENGTH = "segment.length";
    public static final String KEY_SEGMENTCOUNT = "segment.count";
    public static final String KEY_KEYPATTERN = "key.pattern";
    private static final String DEFAULT_SHARDLENGTH = "2";
    private static final String DEFAULT_SEGMENTLENGTH = "2";
    private static final String DEFAULT_SEGMENTCOUNT = "1";
    private static final String DEFAULT_KEYPATTERN = "%s/%s";
    private final int _shardLength;
    private final int _segmentLength;
    private final int _segmentCount;
    private final String _keyPattern;

    public StateStoreConfiguration(Properties properties) {
        this._shardLength = Integer.parseInt(properties.getProperty(KEY_SHARDLENGTH, "2"));
        this._segmentLength = Integer.parseInt(properties.getProperty(KEY_SEGMENTLENGTH, "2"));
        this._segmentCount = Integer.parseInt(properties.getProperty(KEY_SEGMENTCOUNT, DEFAULT_SEGMENTCOUNT));
        this._keyPattern = properties.getProperty(KEY_KEYPATTERN, DEFAULT_KEYPATTERN);
    }

    public String getEntryKey(String idDigest) {
        String shard = idDigest.substring(0, this._shardLength);
        String segmentedDigest = this.getSegmentedRestOfDigest(idDigest);
        return String.format(this._keyPattern, shard, segmentedDigest);
    }

    private String getSegmentedRestOfDigest(String digest) {
        StringBuilder segmentedDigest = new StringBuilder();
        int startPos = this._shardLength;
        if (this._segmentLength > 0) {
            int i = 0;
            while (i < this._segmentCount) {
                segmentedDigest.append(digest, startPos, startPos + this._segmentLength);
                segmentedDigest.append('/');
                startPos += this._segmentLength;
                ++i;
            }
        }
        segmentedDigest.append(digest, startPos, digest.length());
        return segmentedDigest.toString();
    }
}

