/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.digest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestHelper {
    private static final int BYTE_TO_INT_MASK = 255;
    private static final int HIGH_NIBBLE_SHIFT = 4;
    private static final int LOW_NIBBLE_MASK = 15;
    private static final char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private DigestHelper() {
    }

    public static String calculateDigest(String value) {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        try {
            bytes = value.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot happen, utf-8 is always known!");
        }
        return DigestHelper.calculateDigest(bytes);
    }

    public static String calculateDigest(byte[] bytes) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Cannot happen, SHA-256 MUST be available!");
        }
        byte[] hash = digest.digest(bytes);
        return DigestHelper.toHexString(hash);
    }

    public static String toHexString(byte[] hash) {
        StringBuilder hexHash = new StringBuilder();
        int i = 0;
        while (i < hash.length) {
            int hashByte = hash[i] & 0xFF;
            hexHash.append(HEXDIGITS[hashByte >> 4]);
            hexHash.append(HEXDIGITS[hashByte & 0xF]);
            ++i;
        }
        return hexHash.toString();
    }
}

