/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.file;

import java.io.File;
import java.util.Collection;

/**
 * Interface for FileCrawlerService.
 * 
 * @author stuc07
 * 
 */
public interface FileCrawlerService {

  /**
   * List all files of a given directory.
   * 
   * @param directory
   * @return a Collection<File> of files
   */
  Collection<File> listFiles(final File directory);

  /**
   * List all directories of a given directory.
   * 
   * @param directory
   * @return a Collection<File> of directories
   */
  Collection<File> listDirectories(final File directory);
}
