/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.impl;

import org.eclipse.smila.connectivity.framework.performancecounters.AgentControllerPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgentBase;
import org.eclipse.smila.management.LocatedManagementAgent;
import org.eclipse.smila.management.ManagementAgentLocation;
import org.eclipse.smila.management.ManagementRegistration;
import org.osgi.service.component.ComponentContext;

/**
 * Used default connectivity agent.
 */
public class AgentControllerPerformanceAgentImpl extends ConnectivityPerformanceAgentBase implements
  LocatedManagementAgent, AgentControllerPerformanceAgent {

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.management.LocatedManagementAgent#getLocation()
   */
  @Override
  public ManagementAgentLocation getLocation() {
    return ManagementRegistration.INSTANCE.getCategory("Agents").getLocation("Total");
  }

  /**
   * Activate.
   * 
   * @param context
   *          the context
   */
  protected synchronized void activate(final ComponentContext context) {
    ManagementRegistration.INSTANCE.registerAgent(getLocation(), this);
  }

  /**
   * Deactivate.
   * 
   * @param context
   *          the context
   */
  protected synchronized void deactivate(final ComponentContext context) {
    ManagementRegistration.INSTANCE.unregisterAgent(getLocation());
  }

}
