/***********************************************************************************************************************
 * Copyright (c) 2008,2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial creator
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.crawler.web.parse;

import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configurable;
import org.eclipse.smila.connectivity.framework.crawler.web.configuration.Configuration;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.Metadata;
import org.eclipse.smila.connectivity.framework.crawler.web.parse.html.HTMLMetaTags;

/**
 * Fallback implementation to use when no more specialized parser is available. Makes it possible to use the content of
 * binary files linked from web pages (e.g. images or PDF files), the content can of course not be scanned for outgoing
 * links or metadata. Metadata from response headers can be used.
 */
public class BinaryParser implements Parser, Configurable {

  /** parser configuration. */
  private Configuration _configuration;

  @Override
  public void setConf(final Configuration configuration) {
    _configuration = configuration;
  }

  @Override
  public Configuration getConf() {
    return _configuration;
  }

  @Override
  public Parse getParse(final Content content) {
    return new BinaryParse(content, _configuration);
  }

  @Override
  public String[] getContentTypes() {
    return new String[] {};
  }

  /**
   * simple Parse implementation that describes an success result always and makes the response header metadata
   * available. All other results values are empty.
   */
  private class BinaryParse implements Parse {

    /** The _data. */
    private final ParseData _data;

    /**
     * Instantiates a new empty parse impl.
     */
    public BinaryParse(final Content content, final Configuration conf) {
      _data =
        new ParseData(ParseStatus.STATUS_SUCCESS, "", new Outlink[0], content.getMetadata(), new Metadata(),
          new HTMLMetaTags());
      _data.setConf(conf);
    }

    /**
     * {@inheritDoc}
     * 
     * @see org.eclipse.smila.connectivity.framework.crawler.web.parse.Parse#getData()
     */
    @Override
    public ParseData getData() {
      return _data;
    }

    /**
     * Gets the text.
     * 
     * @return the text
     */
    @Override
    public String getText() {
      return "";
    }
  }
}
