/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.importing.crawler.web;

import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskworker.TaskLog;

/**
 * interface for LinkFilter services. The LinkFilter is called on the result of the {@link LinkExtractor} to select only
 * those links that should really be followed in follow-up tasks.
 */
public interface LinkFilter {
  /**
   * filter extracted links.
   * 
   * @param extractedLinks
   *          result from {@link LinkExtractor} service.
   * @param sourceLink
   *          record from which links where extracted.
   * @param parameters
   *          task parameters, can configure the operation.
   * @param taskLog
   *          log facility provided by WorkerManager.
   * @return links to follow in follow-up tasks
   * @throws WebCrawlerException
   *           error in processing the links.
   */
  Collection<Record> filterLinks(Collection<Record> extractedLinks, Record sourceLink, AnyMap parameters,
    TaskLog taskLog) throws WebCrawlerException;
}
