/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing;

/**
 * Class containing general constants for importing.
 * 
 * @author stuc07
 * 
 */
public final class ImportingConstants {

  /**
   * Name of the attribute that contains the delta hash.
   */
  public static final String ATTRIBUTE_DELTA_HASH = "_deltaHash";

  /**
   * Attribute set to <code>true</code> by the deltaCheck worker to mark records that are not new but have been changed.
   */
  public static final String ATTRIBUTE_UPDATE = "_update";

  /**
   * Name of the task parameter that contains the data source.
   */
  public static final String TASK_PARAM_DATA_SOURCE = "dataSource";

  /**
   * Name of the task parameter that contains the root folder for crawling.
   */
  public static final String TASK_PARAM_ROOT_FOLDER = "rootFolder";

  /**
   * Name of the task parameter that contains the start URL for crawling.
   */
  public static final String TASK_PARAM_START_URL = "startUrl";

  /**
   * Private Constructor to avoid instance creation.
   */
  private ImportingConstants() {
  }
}
