/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker;

/** May be used by workers to denote that a task has failed but may be retried. */
public class RecoverableTaskException extends Exception {

  /** serializable. */
  private static final long serialVersionUID = 1L;

  /** . */
  public RecoverableTaskException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** . */
  public RecoverableTaskException(final String message) {
    super(message);
  }

}
