/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.taskworker.input;

/** Input modes. */
public enum InputMode {
  /** Worker uses "Conditional GET" to select tasks with certain objects for this input slot. */
  QUALIFIER("qualifier");

  /** the display name of the Mode. */
  private String _name;

  /**
   * constructs an InputMode.
   * 
   * @param name
   *          The name of the mode.
   */
  InputMode(final String name) {
    _name = name;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return _name;
  }
};
