/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper.internal;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.server.PurgeTxnLog;

public class ZooKeeperGC
implements Runnable {
    private final int _snapshotsToKeep;
    private final long _gcInterval;
    private final File _dataDir;
    private final File _logDir;
    private boolean _stopped;
    private final Log _log = LogFactory.getLog(this.getClass());

    public ZooKeeperGC(long gcInterval, String dataDir, String logDir, int snapshotsToKeep) {
        this._gcInterval = gcInterval;
        this._dataDir = new File(dataDir);
        this._logDir = new File(logDir);
        this._snapshotsToKeep = snapshotsToKeep;
        this._stopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._stopped) {
            ZooKeeperGC zooKeeperGC = this;
            synchronized (zooKeeperGC) {
                try {
                    this.wait(this._gcInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._stopped) continue;
            this.work();
        }
    }

    private void work() {
        try {
            this._log.debug((Object)"GC started.");
            PurgeTxnLog.purge((File)this._logDir, (File)this._dataDir, (int)this._snapshotsToKeep);
            this._log.debug((Object)"GC done.");
        }
        catch (Exception ex) {
            this._log.warn((Object)"GC failed", (Throwable)ex);
        }
    }

    public synchronized void stop() {
        this._stopped = true;
        this.notify();
    }
}

