/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.List;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.httphandler.BaseConnectivityHandler;
import org.eclipse.smila.connectivity.framework.httphandler.ImportNotFoundException;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;

public class CrawlerHandler
extends BaseConnectivityHandler {
    public static final String KEY_JOB_NAME = "jobName";
    public static final String KEY_IMPORT_RUN_ID = "importRunId";
    public static final String KEY_DATA_SOURCE_ID = "dataSourceId";
    private CrawlerController _crawlerController;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("GET".equals(method)) {
            String dataSourceId = this.getDataSourceId(requestUri);
            CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> counterHelper = this._crawlerController.getCrawlerCounterHelper(dataSourceId);
            if (counterHelper == null) {
                throw new ImportNotFoundException("No statistics found for data source id '" + dataSourceId + "'");
            }
            Object instanceAgent = counterHelper.getInstanceAgent();
            AnyMap result = this.createStatistic((ConnectivityPerformanceAgent)instanceAgent, dataSourceId);
            return result;
        }
        if ("POST".equals(method)) {
            if (inputRecord == null) {
                throw new IllegalArgumentException("No attribute 'jobName' provided.");
            }
            String jobName = inputRecord.getMetadata().getStringValue(KEY_JOB_NAME);
            List uriParts = this.getDynamicUriParts(requestUri);
            String dataSourceId = (String)uriParts.get(0);
            int runId = this._crawlerController.startCrawl(dataSourceId, jobName);
            AnyMap result = DataFactory.DEFAULT.createAnyMap();
            result.put(KEY_IMPORT_RUN_ID, (Number)runId);
            return result;
        }
        return null;
    }

    private AnyMap createStatistic(ConnectivityPerformanceAgent crawlerCounters, String dataSourceId) {
        AnyMap result = null;
        result = crawlerCounters != null ? crawlerCounters.toAny() : DataFactory.DEFAULT.createAnyMap();
        result.put(KEY_DATA_SOURCE_ID, dataSourceId);
        CrawlState state = this._crawlerController.getCrawlerTasksState().get(dataSourceId);
        String stateString = state != null ? state.getState().name() : "Undefined";
        result.put("state", stateString);
        return result;
    }

    private String getDataSourceId(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    public void setCrawlerController(CrawlerController crawlerController) {
        this._crawlerController = crawlerController;
    }

    public void unsetCrawlerController(CrawlerController crawlerController) {
        if (crawlerController == this._crawlerController) {
            this._crawlerController = null;
        }
    }
}

