/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonParseException;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.bulkbuilder.InvalidJobException;
import org.eclipse.smila.bulkbuilder.WorkflowRunInfo;
import org.eclipse.smila.bulkbuilder.httphandler.BulkbuilderHandler;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.http.server.json.JsonBulkRequestHandler;

public class BulkbuilderBurstHandler
extends JsonBulkRequestHandler {
    public static final String KEY_WORKFLOW_RUNS = "workflowRuns";
    private final ThreadLocal<Collection<WorkflowRunInfo>> _workflowRunDataToReturn = new ThreadLocal();
    private final ThreadLocal<String> _microBulkId = new ThreadLocal();
    private final Map<String, Boolean> _microBulkHasData = new ConcurrentHashMap<String, Boolean>();
    private BulkbuilderService _service;

    public void start(String method, String requestUri) throws Exception {
        this._microBulkId.set(UUID.randomUUID().toString());
    }

    public void process(String method, String requestUri, Record inputRecord) throws Exception {
        String jobName = this.getJobName(requestUri);
        String microBulkId = this._microBulkId.get();
        WorkflowRunInfo workflowRunInfo = this._service.addToMicroBulk(jobName, inputRecord, microBulkId);
        this._microBulkHasData.put(microBulkId, Boolean.TRUE);
        this.appendIntermediateWorkflowRunInfo(workflowRunInfo);
    }

    public Object finish(String method, String requestUri) throws Exception {
        String jobName = this.getJobName(requestUri);
        String microBulkId = this._microBulkId.get();
        WorkflowRunInfo workflowRunInfo = this._service.finishMicroBulk(jobName, microBulkId);
        this.appendIntermediateWorkflowRunInfo(workflowRunInfo);
        Collection<WorkflowRunInfo> workflowInfos = this._workflowRunDataToReturn.get();
        return this.createResultObject(jobName, workflowInfos);
    }

    private Object createResultObject(String jobName, Collection<WorkflowRunInfo> workflowInfos) throws MalformedURLException {
        if (workflowInfos != null && !workflowInfos.isEmpty()) {
            AnyMap result = FACTORY.createAnyMap();
            AnySeq workflowInfosAny = FACTORY.createAnySeq();
            for (WorkflowRunInfo workflowInfo : workflowInfos) {
                Any singleWorkflowInfo = BulkbuilderHandler.createResponse(workflowInfo, jobName, this.getRequestHost(), this.getRootContextPath());
                workflowInfosAny.add((Object)singleWorkflowInfo);
            }
            result.put(KEY_WORKFLOW_RUNS, (Any)workflowInfosAny);
            return result;
        }
        return null;
    }

    public void end(String method, String requestUri) throws Exception {
        String microBulkId = this._microBulkId.get();
        if (microBulkId != null) {
            this._service.removeMicroBulk(microBulkId);
            this._microBulkHasData.remove(microBulkId);
            this._microBulkId.set(null);
        }
        this._workflowRunDataToReturn.set(null);
    }

    private void appendIntermediateWorkflowRunInfo(WorkflowRunInfo workflowRunInfo) {
        if (workflowRunInfo != null) {
            if (this._workflowRunDataToReturn.get() == null) {
                this._workflowRunDataToReturn.set(new HashSet());
            }
            this._workflowRunDataToReturn.get().add(workflowRunInfo);
        }
    }

    private String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof InvalidRecordException) {
            return 400;
        }
        if (ex instanceof JsonParseException || ex.getCause() != null && ex.getCause() instanceof JsonParseException) {
            return 400;
        }
        if (ex instanceof InvalidJobException) {
            return 404;
        }
        if (ex instanceof BulkbuilderException) {
            return 503;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setBulkbuilderService(BulkbuilderService service) {
        this._service = service;
    }

    public void unsetBulkbuilderService(BulkbuilderService service) {
        if (this._service == service) {
            this._service = null;
        }
    }
}

