/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.filter;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.crawler.web.filter.SimpleLinkFilter;
import org.eclipse.smila.taskworker.TaskLog;

public class FilterConfiguration {
    private final String _startHost;
    private final String _urlPrefix;

    public FilterConfiguration(AnyMap parameters, TaskLog log) {
        this._startHost = this.getStartHost(parameters, log);
        this._urlPrefix = this.getFilterParameterString(parameters, "urlPrefix", log);
    }

    public String getStartHost() {
        return this._startHost;
    }

    public String getUrlPrefix() {
        return this._urlPrefix;
    }

    private String getStartHost(AnyMap parameters, TaskLog log) {
        String urlString = parameters.getStringValue("startUrl");
        if (urlString != null) {
            return SimpleLinkFilter.getHost(urlString, log);
        }
        return null;
    }

    private String getFilterParameterString(AnyMap parameters, String name, TaskLog log) {
        AnyMap filterParameter = this.getFilterParameters(parameters, log);
        if (filterParameter != null) {
            return filterParameter.getStringValue(name);
        }
        return null;
    }

    private AnyMap getFilterParameters(AnyMap parameters, TaskLog log) {
        Any filter = (Any)parameters.get((Object)"filter");
        if (filter != null) {
            if (filter.isMap()) {
                return filter.asMap();
            }
            log.info("Parameter 'filter' is not a map");
        }
        return null;
    }
}

