/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.definitions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.common.definitions.NameValidator;
import org.eclipse.smila.common.definitions.ValueExpression;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;

public final class AccessAny {
    public static final DataFactory FACTORY = DataFactory.DEFAULT;

    private AccessAny() {
    }

    public static Any get(AnyMap any, String fieldName, Any.ValueType fieldType) throws InvalidDefinitionException {
        Any field = null;
        field = (Any)any.get((Object)fieldName);
        if (field != null && field.getValueType() != fieldType) {
            throw new InvalidDefinitionException("Field " + fieldName + " does not have type " + fieldType);
        }
        return field;
    }

    public static ValueExpression getValueExpression(AnyMap any, String fieldName) throws InvalidDefinitionException {
        String expression = AccessAny.getString(any, fieldName);
        if (expression != null) {
            return new ValueExpression(expression);
        }
        return null;
    }

    public static String getString(AnyMap any, String fieldName) throws InvalidDefinitionException {
        Value field = (Value)AccessAny.get(any, fieldName, Any.ValueType.STRING);
        if (field != null) {
            return field.asString();
        }
        return null;
    }

    public static AnySeq getSeq(AnyMap any, String fieldName) throws InvalidDefinitionException {
        Any field = AccessAny.get(any, fieldName, Any.ValueType.SEQ);
        if (field != null) {
            return field.asSeq();
        }
        return null;
    }

    public static boolean getBoolean(AnyMap any, String fieldName, boolean defaultValue) throws InvalidDefinitionException {
        Any field = (Any)any.get((Object)fieldName);
        if (field == null) {
            return defaultValue;
        }
        if (field.isValue()) {
            try {
                return field.asValue().asBoolean();
            }
            catch (InvalidValueTypeException ex) {
                throw new InvalidDefinitionException("Field " + fieldName + " does not have a boolean value.", ex);
            }
        }
        throw new InvalidDefinitionException("Field " + fieldName + " does not have a boolean value.");
    }

    public static ValueExpression getValueExpressionRequired(AnyMap any, String fieldName) throws InvalidDefinitionException {
        return new ValueExpression(AccessAny.getStringRequired(any, fieldName));
    }

    public static String getStringRequired(AnyMap any, String fieldName) throws InvalidDefinitionException {
        String value = AccessAny.getString(any, fieldName);
        if (StringUtils.isEmpty((String)value)) {
            throw new InvalidDefinitionException("Missing field '" + fieldName + "' or it has empty value.");
        }
        return value;
    }

    public static String getValidName(AnyMap any, String fieldName) throws InvalidDefinitionException {
        String name = AccessAny.getStringRequired(any, fieldName);
        try {
            NameValidator.checkName(name);
        }
        catch (InvalidDefinitionException ex) {
            throw new InvalidDefinitionException("Value '" + name + "' in field '" + fieldName + "' is not valid: " + ex.getMessage());
        }
        return name;
    }

    public static List<String> getStringSeq(AnyMap any, String fieldName) throws InvalidDefinitionException {
        AnySeq field = (AnySeq)AccessAny.get(any, fieldName, Any.ValueType.SEQ);
        ArrayList<String> values = null;
        if (field != null) {
            values = new ArrayList<String>();
            for (Any element : field) {
                if (!element.isString()) {
                    throw new InvalidDefinitionException("Sequence in field " + fieldName + " must contain strings only");
                }
                values.add(((Value)element).asString());
            }
        }
        return values;
    }
}

