/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.WorkflowStorage;
import org.osgi.service.component.ComponentContext;

public final class ObjectStoreWorkflowStorage
implements WorkflowStorage {
    private static final int MAX_RETRY_ON_STORE_UNAVAILABLE = 3;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcRecordReader _recordReader = new IpcRecordReader();
    private final IpcAnyWriter _anyWriter = new IpcAnyWriter();
    private boolean _isStorePrepared;
    private String _storeName;
    private ObjectStoreService _objectStore;

    public void setObjectStore(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStore(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    public void setStoreName(String storeName) {
        this._storeName = storeName;
    }

    protected void activate(ComponentContext context) {
        Object storeNameProperty = context.getProperties().get("storeName");
        if (storeNameProperty == null) {
            this._log.error((Object)"Store name property of WorkflowStorage service not set. Service will be disfunctional.");
        }
        this._storeName = storeNameProperty.toString();
    }

    @Override
    public void setWorkflow(String workflowName, AnyMap workflow) throws ProcessingException {
        try {
            this.writeObjectToStore(workflowName, workflow);
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error adding workflow '" + workflowName + "' to store", (Throwable)e);
        }
    }

    @Override
    public void deleteWorkflow(String workflowName) throws ProcessingException {
        try {
            this.removeObjectFromStore(workflowName);
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error deleting workflow '" + workflowName + "' to store", (Throwable)e);
        }
    }

    @Override
    public AnyMap getWorkflow(String workflowName) throws ProcessingException {
        block3: {
            try {
                if (this.existsObjectInStore(workflowName)) break block3;
                return null;
            }
            catch (ObjectStoreException e) {
                throw new ProcessingException("Error getting workflow '" + workflowName + "' from store", (Throwable)e);
            }
        }
        return this.readObjectFromStore(workflowName);
    }

    @Override
    public Collection<String> getWorkflowNames() throws ProcessingException {
        try {
            return this.readObjectNamesFromStore();
        }
        catch (ObjectStoreException e) {
            throw new ProcessingException("Error getting workflow names from store", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private void writeObjectToStore(String objectId, AnyMap object) throws ObjectStoreException {
        Throwable retryableEx = null;
        this.ensureStore();
        int i = 0;
        while (i < 3) {
            StoreOutputStream storeOutputStream = null;
            try {
                storeOutputStream = this._objectStore.writeObject(this._storeName, objectId);
                this._anyWriter.writeJsonStream((Any)object, (OutputStream)storeOutputStream);
            }
            catch (IOException ex) {
                if (storeOutputStream != null) {
                    storeOutputStream.abort();
                }
                retryableEx = ex;
                this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            catch (ServiceUnavailableException ex2) {
                retryableEx = ex2;
                this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex2.toString()));
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(storeOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            IOUtils.closeQuietly((OutputStream)storeOutputStream);
            return;
            ++i;
        }
        throw new ServiceUnavailableException("Finally failed to write object '" + objectId + "' to store", retryableEx);
    }

    private Collection<String> readObjectNamesFromStore() throws ObjectStoreException {
        this.ensureStore();
        TreeSet<String> objectNames = new TreeSet<String>();
        for (StoreObject info : this._objectStore.getStoreObjectInfos(this._storeName)) {
            String objectName = info.getId();
            objectNames.add(objectName);
        }
        return objectNames;
    }

    private AnyMap readObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        Throwable retryableEx = null;
        int i = 0;
        while (i < 3) {
            block7: {
                AnyMap anyMap;
                InputStream jobJsonStream = null;
                try {
                    jobJsonStream = this._objectStore.readObject(this._storeName, objectId);
                    anyMap = this._recordReader.readJsonStream(jobJsonStream).getMetadata();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(jobJsonStream);
                        throw throwable;
                    }
                    catch (IOException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                        break block7;
                    }
                    catch (ServiceUnavailableException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex.toString()));
                    }
                }
                IOUtils.closeQuietly((InputStream)jobJsonStream);
                return anyMap;
            }
            ++i;
        }
        throw new ServiceUnavailableException("Finally failed to read object '" + objectId + "' from store", retryableEx);
    }

    private boolean existsObjectInStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        return ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStore, (String)this._storeName, (String)objectId);
    }

    private void removeObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        this._objectStore.removeObject(this._storeName, objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStore() throws ObjectStoreException {
        if (!this._isStorePrepared) {
            try {
                ObjectStoreWorkflowStorage objectStoreWorkflowStorage = this;
                synchronized (objectStoreWorkflowStorage) {
                    ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this._objectStore, (String)this._storeName);
                    this._isStorePrepared = true;
                }
            }
            catch (ServiceUnavailableException ex) {
                throw new ServiceUnavailableException("Finally failed to prepare store '" + this._storeName + "'", (Throwable)ex);
            }
        }
    }
}

