/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.Date;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class WorkflowsHandler
extends AJobManagerHandler {
    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        AnyMap resultMap = DataFactory.DEFAULT.createAnyMap();
        if (this.isGetRequest(method)) {
            AnySeq workflowList = DataFactory.DEFAULT.createAnySeq();
            boolean returnDetails = false;
            if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)"returnDetails")) {
                returnDetails = inputRecord.getMetadata().getBooleanValue("returnDetails");
            }
            for (String workflowName : defPersistence.getWorkflows()) {
                AnyMap map = DataFactory.DEFAULT.createAnyMap();
                map.put("name", workflowName);
                map.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)workflowName).toExternalForm());
                if (returnDetails && defPersistence.getWorkflow(workflowName).getTimestamp() != null) {
                    map.put("timestamp", (Any)DataFactory.DEFAULT.createDateTimeValue(defPersistence.getWorkflow(workflowName).getTimestamp()));
                }
                workflowList.add((Object)map);
            }
            resultMap.put("workflows", (Any)workflowList);
        }
        if (this.isPostRequest(method)) {
            if (inputRecord == null) {
                throw new IllegalArgumentException("Missing input, cannot create workflows from nothing.");
            }
            AnyMap definition = inputRecord.getMetadata();
            Value timestamp = inputRecord.getFactory().createDateTimeValue(new Date());
            definition.put("timestamp", (Any)timestamp);
            definition.remove((Object)"readOnly");
            WorkflowDefinition createdWorkflow = WorkflowDefinition.parseWorkflow(definition);
            defPersistence.addWorkflow(createdWorkflow);
            resultMap.put("name", createdWorkflow.getName());
            resultMap.put("timestamp", (Any)timestamp);
            resultMap.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)createdWorkflow.getName()).toExternalForm());
        }
        return resultMap;
    }

    protected int getSuccessStatus(String method, String requestUri) {
        if (this.isPostRequest(method)) {
            return 201;
        }
        return super.getSuccessStatus(method, requestUri);
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrPostRequest(method);
    }
}

