/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.management.LocatedManagementAgentBase;
import org.eclipse.smila.solr.SolrManager;

public class SolrManagerAgent
extends LocatedManagementAgentBase {
    private static final String CATEGORY = "Solr";
    private static final String NAME = "ServerManager";
    private final SolrManager _solrManager;

    public SolrManagerAgent(SolrManager solrManager) {
        this._solrManager = solrManager;
    }

    protected String getCategory() {
        return CATEGORY;
    }

    protected String getName() {
        return NAME;
    }

    public String isEmbedded() {
        return String.valueOf(this._solrManager.getSolrProperties().isEmbedded());
    }

    public String getSolrHome() {
        try {
            return this._solrManager.getSolrHelper().getSolrHome().getPath();
        }
        catch (Exception exception) {
            return "Error invoking method: " + exception.getMessage();
        }
    }

    public String getSolrServerURL() {
        return this._solrManager.getSolrProperties().getServerUrl();
    }

    public String getCoreNames() {
        return StringUtils.join(this._solrManager.getCoreNames(), (String)";");
    }

    public String optimize(String coreName) {
        try {
            this._solrManager.getSolrServer(coreName).optimize();
            return "Method successfully invoked.";
        }
        catch (Exception exception) {
            return "Error invoking method: " + exception.getMessage();
        }
    }
}

