/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CoreAdminParams;
import org.eclipse.smila.solr.admin.SolrAdmin;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrHelper;

public abstract class SolrBaseAdmin
implements SolrAdmin {
    protected final Log _log = LogFactory.getLog(SolrAdmin.class);
    protected final SolrHelper _helper;
    private final SolrServers _servers;
    private final Map<String, List<String>> _cachedFieldNames = new HashMap<String, List<String>>();

    public SolrBaseAdmin(SolrHelper helper, SolrServers servers) {
        this._helper = helper;
        this._servers = servers;
    }

    public SolrServers getServers() {
        return this._servers;
    }

    protected Map<String, String[]> buildAdminParams(CoreAdminParams.CoreAdminAction action, String core, String other) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        String[] actionParam = new String[]{action.toString()};
        params.put("action", actionParam);
        if (StringUtils.isNotBlank((String)core)) {
            String[] coreParam = new String[]{core};
            params.put("core", coreParam);
        }
        if (StringUtils.isNotBlank((String)other)) {
            String[] otherCoreParam = new String[]{other};
            params.put("other", otherCoreParam);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFieldNames(String coreName) throws Exception {
        List<String> fieldNames = this._cachedFieldNames.get(coreName);
        if (fieldNames == null) {
            Map<String, List<String>> map = this._cachedFieldNames;
            synchronized (map) {
                fieldNames = this.readFieldNames(coreName);
                this._cachedFieldNames.put(coreName, fieldNames);
            }
        }
        return fieldNames;
    }

    protected abstract List<String> readFieldNames(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCoreCaches() {
        Map<String, List<String>> map = this._cachedFieldNames;
        synchronized (map) {
            this._cachedFieldNames.clear();
            this._servers.removeAllServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCoreCache(String coreName) {
        Map<String, List<String>> map = this._cachedFieldNames;
        synchronized (map) {
            this._cachedFieldNames.remove(coreName);
            this._servers.removeSolrServer(coreName);
        }
    }
}

