/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import java.util.Collection;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.eclipse.smila.solr.server.SolrServers;

public class SolrEmbeddedServers
extends SolrServers {
    private final CoreContainer _container;

    public SolrEmbeddedServers(CoreContainer container) {
        this._container = container;
    }

    @Override
    public SolrServer getAdminServer() throws SolrServerException {
        return this.createServer(this.getAdminCoreName());
    }

    @Override
    protected SolrServer createServer(String coreName) throws SolrServerException {
        if (!this._container.getCoreNames().contains(coreName)) {
            throw new SolrServerException("No configuration found in solr.home '" + this._container.getSolrHome() + "' for core with name: " + coreName);
        }
        return new EmbeddedSolrServer(this._container, coreName);
    }

    private String getAdminCoreName() throws SolrServerException {
        Collection coreNames = this._container.getCoreNames();
        if (coreNames.isEmpty()) {
            throw new SolrServerException("No core available in configuration solr.home '" + this._container.getSolrHome() + "' for admin operations");
        }
        return (String)coreNames.iterator().next();
    }
}

