/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;

public class SecurityUtil {
    public static Subject createSystemPrincipalSubject(String user) {
        HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
        if (user != null) {
            principals.add(new SystemPrincipal(user));
            principals.add(new SystemPrincipal(SecurityUtil.getAuthorizationId(user)));
        }
        boolean readOnly = true;
        HashSet credentials = new HashSet();
        return new Subject(true, principals, credentials, credentials);
    }

    private static String getAuthorizationId(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId(name);
        }
        catch (StandardException se) {
            throw new IllegalArgumentException(se.getMessage());
        }
    }

    public static void checkSubjectHasPermission(final Subject subject, final Permission perm) {
        final PrivilegedAction runCheck = new PrivilegedAction(){

            public Object run() {
                AccessController.checkPermission(perm);
                return null;
            }
        };
        PrivilegedAction runCheckAsPrivilegedUser = new PrivilegedAction(){

            public Object run() {
                AccessControlContext acc = null;
                Subject.doAsPrivileged(subject, runCheck, acc);
                return null;
            }
        };
        AccessController.doPrivileged(runCheckAsPrivilegedUser);
    }

    public static void checkUserHasPermission(String user, Permission perm) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Subject subject = SecurityUtil.createSystemPrincipalSubject(user);
        SecurityUtil.checkSubjectHasPermission(subject, perm);
    }
}

