/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyUtil {
    public static String sortProperties(Properties list) {
        return PropertyUtil.sortProperties(list, null);
    }

    public static String sortProperties(Properties list, String indent) {
        Object key;
        int size = list == null ? 0 : list.size();
        int count = 0;
        Object[] array = new String[size];
        if (list != null) {
            Enumeration<?> propertyNames = list.propertyNames();
            while (propertyNames.hasMoreElements()) {
                if (count == size) {
                    String[] expandedArray = new String[size *= 2];
                    System.arraycopy(array, 0, expandedArray, 0, count);
                    array = expandedArray;
                }
                key = (String)propertyNames.nextElement();
                array[count++] = key;
            }
            Arrays.sort(array, 0, count);
        }
        StringBuffer buffer = new StringBuffer();
        if (indent == null) {
            buffer.append("{ ");
        }
        for (int ictr = 0; ictr < count; ++ictr) {
            if (ictr > 0 && indent == null) {
                buffer.append(", ");
            }
            key = array[ictr];
            if (indent != null) {
                buffer.append(indent);
            }
            buffer.append((String)key);
            buffer.append("=");
            String value = list.getProperty((String)key, "MISSING_VALUE");
            buffer.append(value);
            if (indent == null) continue;
            buffer.append("\n");
        }
        if (indent == null) {
            buffer.append(" }");
        }
        return buffer.toString();
    }

    public static void copyProperties(Properties src_prop, Properties dest_prop) {
        Enumeration<?> propertyNames = src_prop.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            dest_prop.put(key, src_prop.get(key));
        }
    }

    public static void loadWithTrimmedValues(InputStream iStr, Properties prop) throws IOException {
        if (iStr == null || prop == null) {
            return;
        }
        Properties p = new Properties();
        p.load(iStr);
        Enumeration<?> propKeys = p.propertyNames();
        while (propKeys.hasMoreElements()) {
            String tmpKey = (String)propKeys.nextElement();
            String tmpValue = p.getProperty(tmpKey);
            tmpValue = tmpValue.trim();
            prop.put(tmpKey, tmpValue);
        }
    }
}

