/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class UpdateConstantAction
extends WriteCursorConstantAction {
    int[] changedColumnIds;
    private boolean positionedUpdate;
    int numColumns;

    public UpdateConstantAction() {
    }

    public UpdateConstantAction(long conglomId, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, ExecRow emptyHeapRow, boolean deferred, UUID targetUUID, int lockMode, int[] changedColumnIds, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, int numColumns, boolean positionedUpdate, boolean singleRowSource) {
        super(conglomId, heapSCOCI, irgs, indexCIDS, indexSCOCIs, indexNames, deferred, null, targetUUID, lockMode, fkInfo, triggerInfo, emptyHeapRow, baseRowReadList, baseRowReadMap, streamStorableHeapColIds, singleRowSource);
        this.changedColumnIds = changedColumnIds;
        this.positionedUpdate = positionedUpdate;
        this.numColumns = numColumns;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.changedColumnIds = ArrayUtil.readIntArray(in);
        this.positionedUpdate = in.readBoolean();
        this.numColumns = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ArrayUtil.writeIntArray(out, this.changedColumnIds);
        out.writeBoolean(this.positionedUpdate);
        out.writeInt(this.numColumns);
    }

    public int getTypeFormatId() {
        return 39;
    }
}

