/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.xml;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public class StaxRecordWriter {
    private final boolean _printPretty;

    public StaxRecordWriter() {
        this(false);
    }

    public StaxRecordWriter(boolean printPretty) {
        this._printPretty = printPretty;
    }

    public void writeRecord(XMLStreamWriter staxWriter, Record record) throws XMLStreamException {
        this.writeRecord(staxWriter, record, true);
    }

    public void writeRecordList(XMLStreamWriter staxWriter, Iterable<Record> records) throws XMLStreamException {
        staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        this.writeStartElement(staxWriter, "RecordList");
        staxWriter.writeDefaultNamespace("http://www.eclipse.org/smila/record");
        this.newline(staxWriter);
        for (Record record : records) {
            this.writeRecord(staxWriter, record, false);
        }
        this.writeEndElement(staxWriter);
    }

    private void writeRecord(XMLStreamWriter staxWriter, Record record, boolean addNamespace) throws XMLStreamException {
        staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        this.newline(staxWriter);
        this.writeStartElement(staxWriter, "Record");
        if (addNamespace) {
            staxWriter.writeDefaultNamespace("http://www.eclipse.org/smila/record");
        }
        staxWriter.writeAttribute("version", "2.0");
        this.newline(staxWriter);
        if (record.getId() != null) {
            staxWriter.setDefaultNamespace("http://www.eclipse.org/smila/record");
        }
        if (record.getMetadata() != null) {
            this.writeMetadata(staxWriter, record.getMetadata());
        }
        if (record.hasAttachments()) {
            Iterator<String> attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = attachmentNames.next();
                this.writeTextElement(staxWriter, "Attachment", attachmentName);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeMetadata(XMLStreamWriter staxWriter, AnyMap metaData) throws XMLStreamException {
        if (!metaData.isEmpty()) {
            for (Map.Entry entry : metaData.entrySet()) {
                String key = (String)entry.getKey();
                Any any = (Any)entry.getValue();
                if (any.isValue()) {
                    this.writeValue(staxWriter, key, (Value)any);
                    continue;
                }
                if (any.isSeq()) {
                    this.writeSeq(staxWriter, key, (AnySeq)any);
                    continue;
                }
                if (!any.isMap()) continue;
                this.writeMap(staxWriter, key, (AnyMap)any);
            }
        }
    }

    private void writeValue(XMLStreamWriter staxWriter, String key, Value value) throws XMLStreamException {
        Any.ValueType valueType;
        this.writeStartElement(staxWriter, "Val");
        if (key != null) {
            staxWriter.writeAttribute("key", key);
        }
        if ((valueType = value.getValueType()) != Any.ValueType.STRING) {
            staxWriter.writeAttribute("type", valueType.name().toLowerCase());
        }
        this.writeText(staxWriter, value.asString());
        this.writeEndElement(staxWriter);
    }

    private void writeSeq(XMLStreamWriter staxWriter, String key, AnySeq anySeq) throws XMLStreamException {
        this.writeStartElement(staxWriter, "Seq");
        if (key != null) {
            staxWriter.writeAttribute("key", key);
        }
        if (!anySeq.isEmpty()) {
            this.newline(staxWriter);
            for (Any any : anySeq) {
                if (any.isValue()) {
                    this.writeValue(staxWriter, null, (Value)any);
                    continue;
                }
                if (any.isSeq()) {
                    this.writeSeq(staxWriter, null, (AnySeq)any);
                    continue;
                }
                if (!any.isMap()) continue;
                this.writeMap(staxWriter, null, (AnyMap)any);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeMap(XMLStreamWriter staxWriter, String key, AnyMap anyMap) throws XMLStreamException {
        this.writeStartElement(staxWriter, "Map");
        if (key != null) {
            staxWriter.writeAttribute("key", key);
        }
        if (!anyMap.isEmpty()) {
            this.newline(staxWriter);
            for (Map.Entry entry : anyMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                Any any = (Any)entry.getValue();
                if (any.isValue()) {
                    this.writeValue(staxWriter, entryKey, (Value)any);
                    continue;
                }
                if (any.isSeq()) {
                    this.writeSeq(staxWriter, entryKey, (AnySeq)any);
                    continue;
                }
                if (!any.isMap()) continue;
                this.writeMap(staxWriter, entryKey, (AnyMap)any);
            }
        }
        this.writeEndElement(staxWriter);
    }

    private void writeTextElement(XMLStreamWriter staxWriter, String tagName, String value) throws XMLStreamException {
        this.writeStartElement(staxWriter, tagName);
        this.writeText(staxWriter, value);
        this.writeEndElement(staxWriter);
    }

    private void writeText(XMLStreamWriter staxWriter, String value) throws XMLStreamException {
        staxWriter.writeCharacters(StaxRecordWriter.cleanText(value));
    }

    private void writeStartElement(XMLStreamWriter staxWriter, String tagName) throws XMLStreamException {
        staxWriter.writeStartElement("http://www.eclipse.org/smila/record", tagName);
    }

    private void writeEndElement(XMLStreamWriter staxWriter) throws XMLStreamException {
        staxWriter.writeEndElement();
        this.newline(staxWriter);
    }

    private void newline(XMLStreamWriter staxWriter) throws XMLStreamException {
        if (this._printPretty) {
            staxWriter.writeCharacters("\n");
        }
    }

    protected static String cleanText(String text) {
        return StringUtils.replace((String)text, (String)"\u0000", (String)" ");
    }
}

