/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.platform;

import info.aduna.platform.Platform;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlatformBase
implements Platform {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String whitespaceReplacement = "-";
    protected String separatorReplacement = "-";
    protected String colonReplacement = "";

    public File getUserHome() {
        File result = null;
        String userHome = System.getProperty("user.home");
        result = new File(userHome);
        return result;
    }

    public final File getApplicationDataDir() {
        File result;
        String sysProp = System.getProperty("info.aduna.platform.appdata.basedir");
        if (sysProp != null) {
            result = new File(sysProp);
        } else {
            sysProp = System.getProperty("aduna.platform.applicationdata.dir");
            if (sysProp != null) {
                this.logger.info("Old Aduna datadir property \"{}\" detected. This property has been replaced with \"{}\". Support for the old property may be removed in a future version of this application.", (Object)"aduna.platform.applicationdata.dir", (Object)"info.aduna.platform.appdata.basedir");
                result = new File(sysProp);
            } else {
                result = this.getOSApplicationDataDir();
            }
        }
        return result;
    }

    public final File getApplicationDataDir(String applicationName) {
        return new File(this.getApplicationDataDir(), this.getRelativeApplicationDataDir(applicationName));
    }

    public final File getOSApplicationDataDir(String applicationName) {
        return new File(this.getOSApplicationDataDir(), this.getRelativeApplicationDataDir(applicationName));
    }

    public String getRelativeApplicationDataDir(String applicationName) {
        return this.getRelativeApplicationDataDir(applicationName, this.dataDirPreserveCase(), this.dataDirReplaceWhitespace(), this.dataDirReplaceColon());
    }

    public String getRelativeApplicationDataDir(String applicationName, boolean caseSensitive, boolean replaceWhitespace, boolean replaceColon) {
        String result = applicationName.replace(File.separator, this.separatorReplacement);
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        if (replaceWhitespace) {
            result = result.replaceAll("\\s", this.whitespaceReplacement);
        }
        if (replaceColon) {
            result = result.replace(":", this.colonReplacement);
        }
        return result;
    }
}

