/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisUtils {
    private static final Log log = LogFactory.getLog(AxisUtils.class);

    public static void configureService(AxisService axisService, URL uRL) throws IOException, XMLStreamException, AxisFault {
        AxisUtils.configureService(new ConfigurationContext(axisService.getAxisConfiguration()), axisService, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureService(ConfigurationContext configurationContext, AxisService axisService, URL uRL) throws IOException, XMLStreamException, AxisFault {
        InputStream inputStream = uRL.openStream();
        log.debug((Object)("Looking for Axis2 service configuration file: " + uRL));
        if (inputStream != null) {
            log.debug((Object)("Configuring service " + axisService.getName() + " using: " + uRL));
            try {
                if (configurationContext == null) {
                    configurationContext = new ConfigurationContext(axisService.getAxisConfiguration());
                }
                ServiceBuilder serviceBuilder = new ServiceBuilder(inputStream, configurationContext, axisService);
                serviceBuilder.populateService(serviceBuilder.buildOM());
            }
            finally {
                inputStream.close();
            }
            for (int i = 0; i < axisService.getModules().size(); ++i) {
                String string = (String)axisService.getModules().get(i);
                AxisModule axisModule = axisService.getAxisConfiguration().getModule(string);
                if (axisModule == null) {
                    throw new AxisFault("Unable to engage module: " + string);
                }
                axisService.engageModule(axisModule);
            }
        }
    }
}

