/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.utils.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchDog<T, C extends Observer>
implements Runnable {
    public static final long DEFAULT_DELAY = 30000L;
    final Log log = LogFactory.getLog(WatchDog.class);
    private long expire;
    private T lastModif;
    private long delay = 30000L;
    private boolean existedBefore;
    private boolean warnedAlready;
    private boolean interrupted;
    protected Mutable<T> mutable;
    protected C observer;

    public WatchDog() {
    }

    public WatchDog(Mutable<T> mutable, long l) {
        this(mutable);
        this.delay = l;
    }

    public WatchDog(Mutable<T> mutable, C c) {
        this.mutable = mutable;
        this.observer = c;
    }

    public WatchDog(Mutable<T> mutable) {
        this.mutable = mutable;
    }

    public Mutable<T> getMutable() {
        return this.mutable;
    }

    public C getObserver() {
        return this.observer;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    @Override
    public void run() {
        try {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.check();
            }
        }
        catch (Exception exception) {
            this.log.warn((Object)"Exception occured. Thread will stop", (Throwable)exception);
        }
    }

    public final void check() {
        long l = System.currentTimeMillis();
        if (this.expire <= l) {
            this.expire = l + this.delay;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Check for changes: " + this.mutable));
            }
            if (this.mutable.exists()) {
                this.existedBefore = true;
                if (this.lastModif == null || this.mutable.hasChangedSince(this.lastModif)) {
                    this.lastModif = this.mutable.lastModified();
                    this.observer.onUpdate();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)(this.mutable + " updated"));
                    }
                    this.warnedAlready = false;
                }
            } else if (!this.observer.isInitialized()) {
                this.observer.init();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)(this.mutable + " initialized"));
                }
            } else {
                if (this.existedBefore) {
                    this.existedBefore = false;
                    this.lastModif = null;
                    this.observer.onDelete();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)(this.mutable + " deleted"));
                    }
                }
                if (!this.warnedAlready) {
                    this.warnedAlready = true;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)(this.mutable + " does not exist."));
                    }
                }
            }
        }
    }

    public static <C extends Observer> WatchDog<Long, C> watchFile(File file, C c) {
        return new WatchDog<Long, C>(new FileMutable(file), c);
    }

    public static <C extends Observer> WatchDog<Map<File, Long>, C> watchFiles(List<File> list, C c) {
        return new WatchDog<Map<File, Long>, C>(new FileSetMutable(list), c);
    }

    public static class DefaultObserver
    implements Observer {
        public boolean isInitialized() {
            return true;
        }

        public void init() {
        }

        public void onDelete() {
            this.init();
        }

        public void onUpdate() {
            this.init();
        }
    }

    public static interface Observer {
        public boolean isInitialized();

        public void init();

        public void onDelete();

        public void onUpdate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileSetMutable
    implements Mutable<Map<File, Long>> {
        File[] files;

        public FileSetMutable(Collection<File> collection) {
            this.files = new File[collection.size()];
            collection.toArray(this.files);
        }

        public FileSetMutable(File[] fileArray) {
            this.files = fileArray;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean hasChangedSince(Map<File, Long> map) {
            Object object = this.lastModified();
            return !CollectionUtils.equals((Map)object, map);
        }

        @Override
        public Map<File, Long> lastModified() {
            HashMap<File, Long> hashMap = new HashMap<File, Long>(this.files.length * 15 / 10);
            for (File file : this.files) {
                hashMap.put(file, file.lastModified());
            }
            return hashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileMutable
    implements Mutable<Long> {
        File file;

        public FileMutable(File file) {
            this.file = file;
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public boolean hasChangedSince(Long l) {
            return this.lastModified().longValue() != l.longValue();
        }

        @Override
        public Long lastModified() {
            return this.file.lastModified();
        }

        public String toString() {
            return this.file.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutable<T> {
        public boolean exists();

        public boolean hasChangedSince(T var1);

        public T lastModified();
    }
}

