/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.workspace;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class WorkspaceHelper {
    private static final String PROPERTY_WORKSPACE_ROOT = "org.eclipse.smila.utils.workspace.root";
    private static final File WORKSPACE_FOLDER;

    static {
        Log log = LogFactory.getLog(WorkspaceHelper.class);
        String path = System.getProperty(PROPERTY_WORKSPACE_ROOT);
        if (path == null) {
            path = System.getenv(PROPERTY_WORKSPACE_ROOT);
        }
        if (StringUtils.isBlank((String)path)) {
            WORKSPACE_FOLDER = null;
            log.info((Object)"Using default workspace.");
        } else {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (file.exists() && file.isDirectory()) {
                WORKSPACE_FOLDER = file;
                log.info((Object)("Configured Workspace is " + WORKSPACE_FOLDER.getPath()));
            } else {
                WORKSPACE_FOLDER = null;
                log.info((Object)"Configured workspace cannot be created, using default workspace.");
            }
        }
    }

    private WorkspaceHelper() {
    }

    public static File createWorkingDirByBundle(Bundle bundle) throws IOException {
        Log log;
        String bundleName = bundle.getSymbolicName();
        File workingDir = WorkspaceHelper.createWorkingDirInternal(bundleName, log = LogFactory.getLog(WorkspaceHelper.class));
        if (workingDir == null) {
            workingDir = WorkspaceHelper.createDefaultBundleWorkspace(bundleName, log, workingDir, bundle);
        }
        WorkspaceHelper.ensureWorkingDir(bundleName, workingDir);
        return workingDir;
    }

    private static void ensureWorkingDir(String bundleName, File workingDir) throws IOException {
        if (workingDir == null) {
            throw new IOException("Failed to create working directory for bundle " + bundleName + ", see log file for possible reasons.");
        }
    }

    public static File createWorkingDir(String bundleName) throws IOException {
        Log log = LogFactory.getLog(WorkspaceHelper.class);
        File workingDir = WorkspaceHelper.createWorkingDirInternal(bundleName, log);
        WorkspaceHelper.ensureWorkingDir(bundleName, workingDir);
        return workingDir;
    }

    private static File createWorkingDirInternal(String bundleName, Log log) throws IOException {
        File workingDir = WorkspaceHelper.createCustomBundleWorkspace(bundleName, log);
        if (workingDir == null) {
            workingDir = WORKSPACE_FOLDER == null ? WorkspaceHelper.createDefaultBundleWorkspace(bundleName, log) : WorkspaceHelper.ensureDirectory(WORKSPACE_FOLDER, bundleName);
        }
        return workingDir;
    }

    private static File createDefaultBundleWorkspace(String bundleName, Log log) {
        File workingDir = null;
        Bundle bundle = Platform.getBundle((String)bundleName);
        workingDir = WorkspaceHelper.createDefaultBundleWorkspace(bundleName, log, workingDir, bundle);
        return workingDir;
    }

    private static File createDefaultBundleWorkspace(String bundleName, Log log, File workingDir, Bundle bundle) {
        if (bundle == null) {
            log.error((Object)("Bundle " + bundleName + " seems not to be installed, cannot create default working dir."));
        } else {
            IPath location = Platform.getStateLocation((Bundle)bundle);
            if (location == null) {
                log.error((Object)("Platform did not return a state location for bundle " + bundleName + "."));
            } else {
                workingDir = location.toFile();
            }
        }
        return workingDir;
    }

    private static File createCustomBundleWorkspace(String bundleName, Log log) {
        File workingDir = null;
        String bundleWorkspaceProperty = String.valueOf(bundleName) + ".workspace";
        String customBundleWorkspace = System.getProperty(bundleWorkspaceProperty);
        if (customBundleWorkspace == null) {
            customBundleWorkspace = System.getenv(bundleWorkspaceProperty);
        }
        if (!StringUtils.isBlank((String)customBundleWorkspace)) {
            File file;
            if (log.isInfoEnabled()) {
                log.info((Object)("Custom workspace for bundle " + bundleName + " is " + customBundleWorkspace));
            }
            if (!(file = new File(customBundleWorkspace)).exists()) {
                file.mkdirs();
            }
            if (file.exists() && file.isDirectory()) {
                workingDir = file;
            } else {
                log.error((Object)("Creating custom workspace for bundle " + bundleName + " failed, using fallback locations."));
            }
        }
        return workingDir;
    }

    public static File createWorkingDir(String bundleName, String dirName) throws IOException {
        File bundleWorkingDir = WorkspaceHelper.createWorkingDir(bundleName);
        return WorkspaceHelper.ensureDirectory(bundleWorkingDir, dirName);
    }

    public static boolean existsWorkingDir(String bundleName, String dirName) throws IOException {
        File bundleWorkingDir = WorkspaceHelper.createWorkingDir(bundleName);
        File subDirectory = new File(bundleWorkingDir, dirName);
        return subDirectory.exists() && subDirectory.isDirectory();
    }

    private static File ensureDirectory(File directory, String child) throws IOException {
        File subDirectory = new File(directory, child);
        FileUtils.forceMkdir((File)subDirectory);
        return subDirectory;
    }
}

