/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.httphandler;

import java.util.List;

import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.datamodel.Record;

/**
 * Implements the handling of HTTP requests to control (i.e. stop) an agent of a data-source. <br>
 * 
 * URL pattern: <code>smila/agents/&lt;ds-id&gt;/finish</code> <br>
 * 
 * Methods allowed: <code>POST</code>
 */
public class AgentControlHandler extends BaseConnectivityHandler {

  /** Reference to the {@link AgentController}. */
  private AgentController _agentController;

  /**
   * {@inheritDoc}
   */
  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    if (_agentController != null) {
      final List<String> dynamicParts = getDynamicUriParts(requestUri);
      final String dataSourceId = dynamicParts.get(0);
      _agentController.stopAgent(dataSourceId);
    }
    return null;
  }

  /**
   * {@inheritDoc}
   * 
   * only POST allowed.
   */
  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "POST".equals(method);
  }

  /**
   * OSGi method to set the {@link AgentController}. Called by DS.
   * 
   * @param agentController
   */
  protected void setAgentController(final AgentController agentController) {
    _agentController = agentController;
  }

  /**
   * OSGi method to unset the {@link AgentController}. Called by DS.
   * 
   * @param agentController
   */
  protected void unsetAgentController(final AgentController agentController) {
    if (_agentController == agentController) {
      _agentController = null;
    }
  }

}
