/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel;

import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.ProcessingException;

/** interface for storage service for custom workflows. */
public interface WorkflowStorage {

  /** add/update workflow with given name. */
  void setWorkflow(final String workflowName, final AnyMap workflow) throws ProcessingException;

  /** delete workflow with given name. */
  void deleteWorkflow(final String workflowName) throws ProcessingException;

  /** return workflow with given name. */
  AnyMap getWorkflow(final String workflowName) throws ProcessingException;

  /** return names of all stored workflows. */
  Collection<String> getWorkflowNames() throws ProcessingException;

}
