/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.util;

import org.apache.solr.common.params.TermsParams;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

/**
 * TermsQueryConfigAdapter class.
 * 
 * @author pwissel
 * 
 */
public class TermsQueryConfigAdapter {

  /**
   * TermsSort enum.
   * 
   * @author pwissel
   * 
   */
  public enum TermsSort {
    /**
     * count
     */
    COUNT,
    /**
     * index
     */
    INDEX;

    @Override
    public String toString() {
      return this.name().toLowerCase();
    };
  }

  /**
   * The internal map.
   */
  private final AnyMap _map = DataFactory.DEFAULT.createAnyMap();

  /**
   * Constructor.
   * 
   * @param field
   *          the index field name.
   */
  public TermsQueryConfigAdapter(String field) {
    _map.put(TermsParams.TERMS, true);
    _map.put(TermsParams.TERMS_FIELD, field);
  }

  /**
   * Get the underlying AnyMap.
   * 
   * @return the AnyMap.
   */
  public AnyMap getAnyMap() {
    return _map;
  }

  /**
   * Set terms.lower parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsLower(String value) {
    _map.put(TermsParams.TERMS_LOWER, value);
    return this;
  }

  /**
   * Set terms.lower.incl parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsLowerIncl(Boolean value) {
    _map.put(TermsParams.TERMS_LOWER_INCLUSIVE, value);
    return this;
  }

  /**
   * Set terms.mincount parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsMincount(int value) {
    _map.put(TermsParams.TERMS_MINCOUNT, value);
    return this;
  }

  /**
   * Set terms.maxcount parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsMaxcount(int value) {
    _map.put(TermsParams.TERMS_MAXCOUNT, value);
    return this;
  }

  /**
   * Set terms.prefix parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsPrefix(String value) {
    _map.put(TermsParams.TERMS_PREFIX_STR, value);
    return this;
  }

  /**
   * Set terms.limit parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsLimit(int value) {
    _map.put(TermsParams.TERMS_LIMIT, value);
    return this;
  }

  /**
   * Set terms.upper parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsUpper(String value) {
    _map.put(TermsParams.TERMS_UPPER, value);
    return this;
  }

  /**
   * Set terms.upper.incl parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsUpperIncl(Boolean value) {
    _map.put(TermsParams.TERMS_UPPER_INCLUSIVE, value);
    return this;
  }

  /**
   * Set terms.raw parameter.
   * 
   * @param value
   *          the value.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermRaw(Boolean value) {
    _map.put(TermsParams.TERMS_RAW, value);
    return this;
  }

  /**
   * Set terms.sort parameter.
   * 
   * @param sort
   *          the sort.
   * @return TermsQueryConfigAdapter.
   */
  public TermsQueryConfigAdapter setTermsSort(TermsSort sort) {
    _map.put(TermsParams.TERMS_SORT, sort.toString());
    return this;
  }
}
