/***********************************************************************************************************************
 * Copyright (c) 2008,2011 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.datamodel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;

/** default in-memory implementation of Attachments. */
public class InMemoryAttachment implements Attachment, Serializable {

  /** is serializable, so it should have this. */
  private static final long serialVersionUID = 1L;

  /** name of the attachment. */
  private final String _name;

  /** content of the attachment. */
  private final byte[] _content;

  /** create instance. Both arguments must not be null. */
  public InMemoryAttachment(final String name, final byte[] content) {
    if (name == null) {
      throw new IllegalArgumentException("attachment name must not be null");
    }
    if (content == null) {
      throw new IllegalArgumentException("attachment content must not be null");
    }
    this._name = name;
    this._content = content;
  }

  @Override
  public String getName() {
    return _name;
  }

  @Override
  public long size() {
    return _content.length;
  }

  @Override
  public byte[] getAsBytes() {
    return _content;
  }

  @Override
  public byte[] getAsBytes(final int length) {
    if (length >= _content.length) {
      return _content;
    }
    return Arrays.copyOf(_content, length);
  }

  @Override
  public InputStream getAsStream() {
    return new ByteArrayInputStream(_content);
  }

  @Override
  public void dispose() {
    // nothing to do.
  }

  @Override
  public String toString() {
    return "InMemoryAttachment '" + _name + "', size " + size();
  }
}
