/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.importing.VisitedLinksException;

/** Handler for /ias/importing/visited. */
public class VisitedLinksHandler extends AVisitedHandler {

  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method);
  }

  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord) throws Exception {
    return getSources(requestUri);
  }

  /** create list of current sources. */
  private AnyMap getSources(final String requestUri) throws VisitedLinksException, MalformedURLException {
    final AnyMap result = DataFactory.DEFAULT.createAnyMap();
    final AnySeq sources = result.getSeq("sources", true);
    final Collection<String> sourceIds = _visitedService.getSourceIds();
    for (final String sourceId : sourceIds) {
      final AnyMap source = sources.getFactory().createAnyMap();
      sources.add(source);
      source.put("id", sourceId);
      source.put("url", URLCreator.create(getRequestHost(), requestUri, sourceId).toString());
    }
    return result;
  }

}
