/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.agent.jobfile;

import org.eclipse.smila.connectivity.framework.AgentCriticalException;
import org.eclipse.smila.datamodel.Record;

/**
 * Interface JobFileHandler that is used by JobFileReader to add or delete parsed Records and Ids.
 */
public interface JobFileHandler {
  /**
   * Add the given record.
   * 
   * @param record
   *          the record to add
   */
  void add(final Record record) throws AgentCriticalException;

  /**
   * Delete the given record.
   * 
   * @param record
   *          the record to delete
   */
  void delete(final Record record) throws AgentCriticalException;
}
