/*******************************************************************************
 * Copyright (c) 2008, 2009 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.blackboard;

/**
 * Factory service to create blackboard instances.
 * 
 * @author jschumacher
 * 
 */
public interface BlackboardFactory {

  /**
   * creates a blackboard.
   * 
   * @param useRecordStorage
   *          if <code>true</code>, the records will be stored using the RecordStorage service.
   * @param useBinaryStorage
   *          if <code>true</code>, the attachments will be stored using the BinaryStorage service.
   * @return a blackboard with the desired storages attached to it.
   * @throws BlackboardAccessException
   *           could not create the blackboard, or one of the desired services is not available.
   */
  Blackboard createBlackboard(boolean useRecordStorage, boolean useBinaryStorage) throws BlackboardAccessException;

  /**
   * create a new persisting blackboard instance. If a record storage is available, it will be used. The Blackboard uses
   * a binary storage to store attachments.
   * 
   * @return blackboard instance that does persist into storages.
   * @throws BlackboardAccessException
   *           could not create the blackboard, or no binary storage service is available.
   */
  Blackboard createPersistingBlackboard() throws BlackboardAccessException;

  /**
   * create a new non-persisting blackboard instance. This method must always return a valid empty blackboard instance.
   * 
   * @return blackboard instance that does not persist into storages.
   */
  Blackboard createTransientBlackboard();
}
