/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker;

/**
 * Interface for task workers implementing the worker function {@link Worker#perform(TaskContext)}.
 * 
 * The implementation must be thread safe.
 */
public interface Worker {
  /**
   * Performs a computation on the data available in the {@link TaskContext}, such as a task for this worker, input and
   * (if configured) output slots. An implementor must make sure, calls to this method must be thread-safe!
   * 
   * @param taskContext
   *          the TaskContext information with which this operation can be performed.
   */
  void perform(final TaskContext taskContext) throws Exception;

  /**
   * @return the name of the worker. The worker function will be executed for tasks tied to this worker name.
   */
  String getName();
}
