/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.ODEProcess;

class MyRoleMessageExchangeCache {
    private static final int CLEANUP_PERIOD = 20;
    private Map<String, WeakReference<MyRoleMessageExchangeImpl>> _cache = new ConcurrentHashMap<String, WeakReference<MyRoleMessageExchangeImpl>>();
    private int _inserts = 0;

    MyRoleMessageExchangeCache() {
    }

    void put(MyRoleMessageExchangeImpl myRoleMessageExchangeImpl) {
        WeakReference<MyRoleMessageExchangeImpl> weakReference;
        ++this._inserts;
        if (this._inserts > 20) {
            this.cleanup();
        }
        if ((weakReference = this._cache.get(myRoleMessageExchangeImpl.getMessageExchangeId())) != null && weakReference.get() != null) {
            throw new IllegalStateException("InternalError: duplicate myrolemex registration!");
        }
        this._cache.put(myRoleMessageExchangeImpl.getMessageExchangeId(), new WeakReference<MyRoleMessageExchangeImpl>(myRoleMessageExchangeImpl));
    }

    MyRoleMessageExchangeImpl get(MessageExchangeDAO messageExchangeDAO, ODEProcess oDEProcess) {
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl;
        WeakReference<MyRoleMessageExchangeImpl> weakReference = this._cache.get(messageExchangeDAO.getMessageExchangeId());
        MyRoleMessageExchangeImpl myRoleMessageExchangeImpl2 = myRoleMessageExchangeImpl = weakReference == null ? null : (MyRoleMessageExchangeImpl)weakReference.get();
        if (myRoleMessageExchangeImpl == null) {
            myRoleMessageExchangeImpl = oDEProcess.recreateMyRoleMex(messageExchangeDAO);
            this._cache.put(messageExchangeDAO.getMessageExchangeId(), new WeakReference<MyRoleMessageExchangeImpl>(myRoleMessageExchangeImpl));
        }
        return myRoleMessageExchangeImpl;
    }

    private void cleanup() {
        Iterator<WeakReference<MyRoleMessageExchangeImpl>> iterator = this._cache.values().iterator();
        while (iterator.hasNext()) {
            WeakReference<MyRoleMessageExchangeImpl> weakReference = iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        this._inserts = 0;
    }
}

