/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.hunspell.HunspellDictionary;
import org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class HunspellStemFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private static final String PARAM_DICTIONARY = "dictionary";
    private static final String PARAM_AFFIX = "affix";
    private static final String PARAM_IGNORE_CASE = "ignoreCase";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private HunspellDictionary dictionary;
    private boolean ignoreCase = false;

    public void inform(ResourceLoader loader) {
        this.assureMatchVersion();
        String[] dictionaryFiles = ((String)this.args.get(PARAM_DICTIONARY)).split(",");
        String affixFile = (String)this.args.get(PARAM_AFFIX);
        String pic = (String)this.args.get(PARAM_IGNORE_CASE);
        if (pic != null) {
            if (pic.equalsIgnoreCase(TRUE)) {
                this.ignoreCase = true;
            } else if (pic.equalsIgnoreCase(FALSE)) {
                this.ignoreCase = false;
            } else {
                throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Unknown value for ignoreCase: " + pic + ". Must be true or false");
            }
        }
        try {
            ArrayList<InputStream> dictionaries = new ArrayList<InputStream>();
            for (String file : dictionaryFiles) {
                dictionaries.add(loader.openResource(file));
            }
            this.dictionary = new HunspellDictionary(loader.openResource(affixFile), dictionaries, this.luceneMatchVersion, this.ignoreCase);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load hunspell data! [dictionary=" + (String)this.args.get(PARAM_DICTIONARY) + ",affix=" + affixFile + "]", e);
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary);
    }
}

