/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.derby.impl.load.LoadError;

class ColumnInfo {
    private ArrayList vtiColumnNames = new ArrayList(1);
    private ArrayList insertColumnNames = new ArrayList(1);
    private ArrayList columnTypes = new ArrayList(1);
    private ArrayList jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;

    public ColumnInfo(Connection conn, String sName, String tName, String insertColumnList, String vtiColumnIndexes, String vtiColumnPrefix) throws SQLException {
        StringTokenizer st;
        this.conn = conn;
        this.schemaName = sName;
        this.tableName = tName;
        if (insertColumnList != null) {
            st = new StringTokenizer(insertColumnList, ",");
            while (st.hasMoreTokens()) {
                String columnName = st.nextToken().trim();
                if (this.initializeColumnInfo(columnName)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(columnName);
                }
                String entityName = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(entityName);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String entityName = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(entityName);
        }
        if (vtiColumnIndexes != null) {
            st = new StringTokenizer(vtiColumnIndexes, ",");
            while (st.hasMoreTokens()) {
                String columnIndex = st.nextToken().trim();
                this.vtiColumnNames.add(vtiColumnPrefix + columnIndex);
                int cIndex = new Integer(columnIndex);
                if (cIndex <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = cIndex;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int index = 1; index <= this.noOfColumns; ++index) {
                this.vtiColumnNames.add(vtiColumnPrefix + index);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private boolean initializeColumnInfo(String columnPattern) throws SQLException {
        DatabaseMetaData dmd = this.conn.getMetaData();
        ResultSet rs = dmd.getColumns(null, this.schemaName, this.tableName, columnPattern);
        boolean foundTheColumn = false;
        while (rs.next()) {
            String columnName = rs.getString(4);
            short dataType = rs.getShort(5);
            String typeName = rs.getString(6);
            int columnSize = rs.getInt(7);
            int decimalDigits = rs.getInt(9);
            int numPrecRadix = rs.getInt(10);
            foundTheColumn = true;
            if (ColumnInfo.importExportSupportedType(dataType)) {
                this.insertColumnNames.add(columnName);
                String sqlType = typeName + this.getTypeOption(typeName, columnSize, columnSize, decimalDigits);
                this.columnTypes.add(sqlType);
                this.jdbcColumnTypes.add(new Integer(dataType));
                ++this.noOfColumns;
                continue;
            }
            rs.close();
            throw LoadError.nonSupportedTypeColumn(columnName, typeName);
        }
        rs.close();
        return foundTheColumn;
    }

    public static final boolean importExportSupportedType(int type) {
        return type != -7 && type != 2000 && type != 1111 && type != 2009;
    }

    private String getTypeOption(String type, int length, int precision, int scale) {
        if ((type.equals("CHAR") || type.equals("BLOB") || type.equals("CLOB") || type.equals("VARCHAR")) && length != 0) {
            return "(" + length + ")";
        }
        if (type.equals("FLOAT") && precision != 0) {
            return "(" + precision + ")";
        }
        if (type.equals("DECIMAL") || type.equals("NUMERIC")) {
            if (precision != 0 && scale == 0) {
                return "(" + precision + ")";
            }
            if (precision != 0 && scale != 0) {
                return "(" + precision + "," + scale + ")";
            }
            if (precision == 0 && scale != 0) {
                return "(" + scale + ")";
            }
        }
        if ((type.equals("DECIMAL") || type.equals("NUMERIC")) && scale != 0) {
            return "(" + scale + ")";
        }
        return "";
    }

    public String getColumnNamesWithCasts() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int noOfVtiCols = this.vtiColumnNames.size();
        for (int index = 0; index < this.noOfColumns && index < noOfVtiCols; ++index) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            String type = (String)this.columnTypes.get(index);
            String columnName = (String)this.vtiColumnNames.get(index);
            if (type.startsWith("SMALLINT") || type.startsWith("INTEGER") || type.startsWith("DECIMAL") || type.startsWith("BIGINT") || type.startsWith("NUMERIC")) {
                sb.append(" cast(" + columnName + " AS " + type + ") ");
                continue;
            }
            if (type.startsWith("DOUBLE")) {
                sb.append(" DOUBLE(" + columnName + ") ");
                continue;
            }
            if (type.startsWith("REAL")) {
                sb.append("cast( DOUBLE(" + columnName + ") " + " AS " + "REAL" + ") ");
                continue;
            }
            sb.append(" " + columnName + " ");
        }
        if (first) {
            return " * ";
        }
        return sb.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int index = 0; index < this.noOfColumns; ++index) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("\"");
            sb.append(this.insertColumnNames.get(index));
            sb.append("\"");
        }
        if (first) {
            return null;
        }
        return sb.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData dmd = this.conn.getMetaData();
        ResultSet rs = dmd.getTables(null, this.schemaName, this.tableName, null);
        boolean foundTable = false;
        if (rs.next()) {
            foundTable = true;
        }
        rs.close();
        return foundTable;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuffer vtiColumnTypes = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.noOfColumns && i < this.vtiColumnNames.size(); ++i) {
            if (first) {
                first = false;
            } else {
                vtiColumnTypes.append(",");
            }
            vtiColumnTypes.append(this.vtiColumnNames.get(i) + ":" + this.jdbcColumnTypes.get(i));
        }
        if (first) {
            return null;
        }
        return vtiColumnTypes.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String columnTypesStr, int noOfColumns) {
        int[] vtiColumnTypes = new int[noOfColumns];
        for (int i = 0; i < noOfColumns; ++i) {
            vtiColumnTypes[i] = 12;
        }
        StringTokenizer st = new StringTokenizer(columnTypesStr, ",");
        while (st.hasMoreTokens()) {
            String colTypeInfo = st.nextToken().trim();
            int colTypeOffset = colTypeInfo.indexOf(":");
            int colIndex = new Integer(colTypeInfo.substring(6, colTypeOffset));
            int colType = new Integer(colTypeInfo.substring(colTypeOffset + 1));
            if (colIndex > noOfColumns) continue;
            vtiColumnTypes[colIndex - 1] = colType;
        }
        return vtiColumnTypes;
    }
}

