/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder.test;

import org.eclipse.smila.bulkbuilder.outputs.AppendableBulkOutput;
import org.eclipse.smila.bulkbuilder.outputs.BulkOutput;
import org.eclipse.smila.bulkbuilder.outputs.BulkType;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.output.AppendableOutput;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Tests the {@link BulkOutput} classes.
 * 
 */
public class TestBulkOutputs extends DeclarativeServiceTestCase {

  /** dummy job name. */
  private static final String JOB_NAME = "JOB";

  /** dummy bulk id. */
  private static final String BULK_ID = "BULK ID";

  /** object store. */
  private ObjectStoreService _objectStoreService;

  /**
   * {@inheritDoc}
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _objectStoreService = getService(ObjectStoreService.class);
    assertNotNull(_objectStoreService);
  }

  /** tests the {@link BulkOutput#isTimedOut()} method. */
  public void testIsTimedOut() throws Exception {
    final BulkOutput bulk = new AppendableBulkOutput(JOB_NAME, BULK_ID, BulkType.ADD);
    bulk.setCommitTimeout(200);
    assertFalse(bulk.isTimedOut());
    Thread.sleep(300);
    bulk.setLastModificationTime(System.currentTimeMillis());
    assertTrue(bulk.isTimedOut());
  }

  /**
   * Tests the bulk limit sizes.
   */
  public void testSetBulkSizeLimit() throws Exception {
    final BulkOutput bulk = new AppendableBulkOutput(JOB_NAME, BULK_ID, BulkType.ADD);
    final String storeName = "test";
    final BulkInfo bi = new BulkInfo("test-bucket", storeName, BULK_ID);
    _objectStoreService.ensureStore(storeName);
    bulk.setBulk(new AppendableOutput(bi, _objectStoreService));
    assertFalse(bulk.hasGrownBeyondLimit());
    assertTrue(bulk.getBulkSizeLimit() < 0);
    assertEquals(0, bulk.getBytesWritten());
    bulk.setBulkSizeLimit(0);
    assertFalse(bulk.hasGrownBeyondLimit());
    final Record record = DataFactory.DEFAULT.createRecord("0");
    record.getMetadata().put("content", "here is some content.");
    bulk.addRecord(record);
    assertTrue(bulk.getBytesWritten() > record.getMetadata().getStringValue("content").getBytes().length);
    assertTrue(bulk.hasGrownBeyondLimit());
    assertEquals(0, bulk.getBulkSizeLimit());
    bulk.setBulkSizeLimit(bulk.getBytesWritten() + 1);
    assertFalse(bulk.hasGrownBeyondLimit());
  }
}
