/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.clusterconfig.simple.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.clusterconfig.ClusterConfigService;
import org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService;
import org.junit.Test;

/**
 *
 */
public class TestSimpleClusterConfigDefaultValues {

  /**
   * the service to test. We do not want to get it as a activated service, since we'd rather like to test the defaults
   * here.
   */
  private final ClusterConfigService _service = new SimpleClusterConfigService();

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getClusterNodes()}.
   * 
   * @throws ClusterConfigException
   *           to be honest, this can't happen here, since we're using {@link SimpleClusterConfigService}.
   */
  @Test
  public void testGetClusterNodes() throws ClusterConfigException {
    final Collection<String> cluster = _service.getClusterNodes();
    assertEquals(1, cluster.size());
    assertTrue(cluster.contains(_service.getLocalHost()));
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getLocalHost()}.
   * 
   * @throws UnknownHostException
   *           failed in getting local inet adress
   */
  @Test
  public void testGetLocalHost() throws UnknownHostException {
    final InetAddress inetAddress = InetAddress.getLocalHost();
    assertEquals(inetAddress.getHostName(), _service.getLocalHost());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getZkGcInterval()}.
   */
  @Test
  public void testGetZkGcInterval() {
    assertEquals(SimpleClusterConfigService.DEFAULT_ZK_GC_INTERVAL, _service.getZkGcInterval());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getFailSafetyLevel()}.
   */
  @Test
  public void testGetFailSafetyLevel() {
    assertEquals(SimpleClusterConfigService.DEFAULT_FAILSAFETY_LEVEL, _service.getFailSafetyLevel());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#isConfigured()}.
   */
  @Test
  public void testIsConfigured() {
    assertFalse(_service.isConfigured());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getMaxScaleUp()}.
   */
  @Test
  public void testGetMaxScaleUp() {
    assertEquals(SimpleClusterConfigService.DEFAULT_MAX_SCALE_UP, _service.getMaxScaleUp());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getMaxRetries()}.
   */
  @Test
  public void testGetMaxRetries() {
    assertEquals(SimpleClusterConfigService.DEFAULT_MAX_RETRIES, _service.getMaxRetries());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getTimeToLive()}.
   */
  @Test
  public void testGetTimeToLive() {
    assertEquals(SimpleClusterConfigService.DEFAULT_TIME_TO_LIVE, _service.getTimeToLive());
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#isResumeJobs()}.
   */
  @Test
  public void testIsResumeJobs() {
    assertEquals(SimpleClusterConfigService.DEFAULT_RESUME_JOBS, _service.isResumeJobs());
  }

  /**
   * Test method for
   * {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getWorkerScaleUp(java.lang.String)}.
   */
  @Test
  public void testGetWorkerScaleUp() {
    assertEquals(SimpleClusterConfigService.DEFAULT_MAX_SCALE_UP, _service.getWorkerScaleUp("node1"));
    assertEquals(SimpleClusterConfigService.DEFAULT_MAX_SCALE_UP, _service.getWorkerScaleUp("node5"));
  }

  /**
   * Test method for {@link org.eclipse.smila.clusterconfig.simple.SimpleClusterConfigService#getWorkersWithScaleUp()}.
   */
  @Test
  public void testGetWorkersWithScaleUp() {
    final Collection<String> workersWithScaleUp = _service.getWorkersWithScaleUp();
    assertNotNull(workersWithScaleUp);
    assertTrue(workersWithScaleUp.isEmpty());
  }

}
