/***********************************************************************************************************************
 * Copyright (c) 2008,2011 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the 
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation               
 **********************************************************************************************************************/

package org.eclipse.smila.datamodel.ipc.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;

/** Test Any (de-)serialization. */
public class TestAnySerialization extends TestCase {

  private final IpcAnyWriter _writer = new IpcAnyWriter();

  private final IpcAnyReader _reader = new IpcAnyReader();

  /**
   * tests serialization and deserialization of an null value to and from JSON.
   */
  public void testNullJSON() throws Exception {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    _writer.writeJsonStream(null, baos);
    final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    final Any res = _reader.readJsonStream(bais);
    assertTrue(res == null);
  }

  /**
   * tests serialization and deserialization of an empty map to and from JSON.
   */
  public void testEmptyJSON() throws Exception {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    _writer.writeJsonStream(DataFactory.DEFAULT.createAnyMap(), baos);
    final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    final Any res = _reader.readJsonStream(bais);
    assertEquals(DataFactory.DEFAULT.createAnyMap(), res);
  }

  /**
   * tests serialization and deserialization of an null value to and from BON.
   */
  public void testNullBON() throws Exception {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    _writer.writeBinaryStream(null, baos);
    final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    final Any res = _reader.readBinaryStream(bais);
    assertTrue(res == null);
  }

  /**
   * tests serialization and deserialization of an empty map to and from BON.
   */
  public void testEmptyBON() throws Exception {
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    _writer.writeBinaryStream(DataFactory.DEFAULT.createAnyMap(), baos);
    final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
    final Any res = _reader.readBinaryStream(bais);
    assertEquals(DataFactory.DEFAULT.createAnyMap(), res);
  }
}
